/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class WeaponsLeftAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"weapons_left", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user shoots bullets from their left hand.", null)});
    private static final float COOLDOWN = 25.0f;
    public static final AbilityCore<WeaponsLeftAbility> INSTANCE = new AbilityCore.Builder("Weapons Left", AbilityCategory.RACIAL, WeaponsLeftAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)25.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(WeaponsLeftAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private ItemStack bullets;

    public WeaponsLeftAbility(AbilityCore<WeaponsLeftAbility> core) {
        super(core);
        this.isNew = true;
        this.bullets = null;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.animationComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(ModItems.BULLET.get())) continue;
            this.bullets = itemStack;
            break;
        }
        if (this.bullets == null || this.bullets.func_190916_E() == 0) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need bullets to fire!"), entity.func_110124_au());
            return;
        }
        this.projectileComponent.shoot(entity, 4.0f, 1.2f);
        this.bullets.func_190918_g(1);
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 7);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.5f + entity.func_70681_au().nextFloat() / 5.0f);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        this.cooldownComponent.startCooldown(entity, 25.0f);
    }

    private NormalBulletProjectile createProjectile(LivingEntity entity) {
        NormalBulletProjectile proj = new NormalBulletProjectile(entity.field_70170_p, entity);
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        if (props.isSniper()) {
            proj.setDamage(16.0f);
        } else {
            proj.setDamage(10.0f);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isCyborg();
    }
}

