/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.CyborgHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.FreshFireProjectile;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ReworkedFreshFireAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"fresh_fire", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user heats up and breathes fire like a flamethrower at the opponenty.", null)});
    private static final float COOLDOWN = 100.0f;
    private static final int COLA_REQUIRED = 1;
    private static final int MAX_FIRE_BURSTS = 10;
    public static final AbilityCore<ReworkedFreshFireAbility> INSTANCE = new AbilityCore.Builder("Fresh Fire", AbilityCategory.RACIAL, ReworkedFreshFireAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f), CyborgHelper.getColaTooltip((float)10.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).setUnlockCheck(ReworkedFreshFireAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::startContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(100, this::triggerRepeaterEvent).addStopEvent(100, this::stopRepeaterEvent);

    public ReworkedFreshFireAbility(AbilityCore<ReworkedFreshFireAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.projectileComponent, this.repeaterComponent});
        this.addCanUseCheck(CyborgHelper.hasEnoughCola((int)1));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.startContinuity(entity, -1.0f);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 10, 3);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        this.projectileComponent.shoot(entity, 2.5f, 3.0f);
        props.alterCola(-1);
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo((Object)new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
        }
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private FreshFireProjectile createProjectile(LivingEntity entity) {
        FreshFireProjectile proj = new FreshFireProjectile(entity.field_70170_p, entity, (Ability)this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isCyborg();
    }
}

