/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ReworkedColaOverdriveAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"cola_overdrive", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user absorbs cola from their reserves to boost their physical abilities.", null)});
    private static final int DRAIN_PER_TICK = 1;
    private static final float HOLD_TIME = 500.0f;
    private static final float BASE_COOLDOWN = 100.0f;
    private static final AbilityDescriptionLine.IDescriptionLine COLA_TOOLTIP = (e, a) -> {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)e);
        int half = (int)Math.floor((float)props.getMaxCola() / 2.0f);
        AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_COLA, half);
        return statBuilder.build().getStatDescription();
    };
    public static final AbilityCore<ReworkedColaOverdriveAbility> INSTANCE = new AbilityCore.Builder("Cola Overdrive", AbilityCategory.RACIAL, ReworkedColaOverdriveAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)600.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(ReworkedColaOverdriveAbility::canUnlock).build();
    private static final AbilityAttributeModifier MOVEMENT_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("876d97f9-d8a1-487c-af05-ca97d90deb90"), INSTANCE, "Cola Overdrive Movement Speed Multiplier", 0.275, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier SWIM_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("876d97f9-d8a1-487c-af05-ca97d90deb90"), INSTANCE, "Cola Overdrive Swim Speed Multiplier", 1.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("74ddb8cc-1d53-47be-9ed8-ff1d26e8b665"), INSTANCE, "Cola Overdrive Jump Height Multiplier", 2.55, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_RESISTANCE_MODIFIER = new AbilityAttributeModifier(UUID.fromString("9120f731-0f9e-4c12-908c-1d4142daacce"), INSTANCE, "Cola Overdrive Fall Resistance Multiplier", 5.75, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("43f604bd-1ab3-4a27-9b10-bac40ade0e29"), INSTANCE, "Cola Overdrive Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("a4c7f767-963b-477b-bc75-85458b4c3c79"), INSTANCE, "Cola Overdrive Reach Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    private final Interval colaDrain = new Interval(2);

    public ReworkedColaOverdriveAbility(AbilityCore<ReworkedColaOverdriveAbility> core) {
        super(core);
        this.isNew = true;
        Predicate<LivingEntity> isContinuityActive = entity -> this.continuousComponent.isContinuous();
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_SPEED_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier)ForgeMod.SWIM_SPEED, (AttributeModifier)SWIM_SPEED_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_HEIGHT_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_RESISTANCE_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isContinuityActive);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isContinuityActive);
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent});
        super.addCanUseCheck(this::canUseAbility);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 500.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.colaDrain.restartIntervalToZero();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        if (this.colaDrain.canTick()) {
            props.alterCola(-1);
            if (entity instanceof ServerPlayerEntity) {
                WyNetwork.sendTo((Object)new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
            }
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 0));
        AbilityUseResult result = this.canUseAbility(entity, (IAbility)this);
        if (result.isFail()) {
            entity.func_145747_a(result.getMessage(), Util.field_240973_b_);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime());
    }

    private AbilityUseResult canUseAbility(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        return props.getCola() <= 0 ? AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA) : AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isCyborg();
    }
}

