/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.cybrogextra.CartStrongRightProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.cybrogextra.ImpactfulRightProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class IronBoxingAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"iron_boxing", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user unleashes a barrage of iron punches.", null), ImmutablePair.of((Object)"The user unleashes a barrage of BIGGER iron punches.", null)});
    private static final TranslationTextComponent IRON_BOXING_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.strong_right", "Strong Right"));
    private static final ResourceLocation IMPACTFUL_ICON = new ResourceLocation("cartaddon", "textures/abilities/impactful_boxing.png");
    private static final TranslationTextComponent IMPACTFUL_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.impactful_boxing", "Impactful Boxing"));
    private static final float COOLDOWN = 240.0f;
    public static final AbilityCore<IronBoxingAbility> INSTANCE = new AbilityCore.Builder("Iron Boxing", AbilityCategory.RACIAL, IronBoxingAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> IRON_BOXING_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)4.0f), CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> IMPACTFUL_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)6.0f), CooldownComponent.getTooltip((float)400.0f)}).setSourceType(new SourceType[]{SourceType.FIST}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(IronBoxingAbility::canUnlock).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private float cooldown;
    private int triggers;
    private int interval;
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.STRONG, true).addChangeModeEvent(this::onAltModeChange);

    public IronBoxingAbility(AbilityCore<IronBoxingAbility> core) {
        super(core);
        this.isNew = true;
        this.cooldown = 300.0f;
        this.triggers = 7;
        this.interval = 8;
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 4; ++i) {
                this.projectileComponent.shootWithSpread(living, 1.25f, 1.0f, 1);
            }
        });
        super.addComponents(new AbilityComponent[]{this.animationComponent, this.altModeComponent});
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
        super.addCanUseCheck(BaraHelper::hasLimbs);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
        if (this.altModeComponent.getCurrentMode() == Mode.STRONG) {
            this.cooldown = 300.0f;
        } else if (this.altModeComponent.getCurrentMode() == Mode.IMPACTFUL) {
            this.cooldown = 400.0f;
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.repeaterComponent.stop(entity);
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        AbilityProjectileEntity projectile = new CartStrongRightProjectile(entity.field_70170_p, entity, (Ability)this);
        projectile.setDamage(5.0f);
        projectile.setLife(8);
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACTFUL) {
            projectile = new ImpactfulRightProjectile(entity.field_70170_p, entity, (Ability)this);
            projectile.setDamage(6.0f);
            projectile.setLife(6);
        }
        return projectile;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.STRONG) {
            this.setDisplayIcon(INSTANCE);
            this.setDisplayName((ITextComponent)INSTANCE.getLocalizedName());
        } else if (mode == Mode.IMPACTFUL) {
            this.setDisplayIcon(IMPACTFUL_ICON);
            this.setDisplayName((ITextComponent)IMPACTFUL_NAME);
        }
    }

    public void switchStrong(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.STRONG);
    }

    public void switchImpact(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.IMPACTFUL);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        return props.isCyborg();
    }

    public static enum Mode {
        STRONG,
        IMPACTFUL;

    }
}

