/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.cyborgextra.CartStrongRightAbility;
import net.MrMagicalCart.cartaddon.abilities.cyborgextra.IronBoxingAbility;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class GeneralFrankyAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"general_franky", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user transforms into the coolest thing possible. (35% damage reduction!)", null)});
    public static final AbilityCore<GeneralFrankyAbility> INSTANCE = new AbilityCore.Builder("General Franky", AbilityCategory.RACIAL, GeneralFrankyAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)500.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(GeneralFrankyAbility::canUnlock).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "General Franky Movement Modifier", -0.025, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "General Franky Armor Modifier", 20.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "General Franky Strength Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "General Franky Attack Speed Modifier", 0.15, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_BOOST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "General Franky Jump Modifier", 1.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "General Franky Reach Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "General Franky Armor Toughness Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "General Franky Toughness Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);

    public GeneralFrankyAbility(AbilityCore<GeneralFrankyAbility> core) {
        super(core);
        super.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isMorphed);
        this.continuousComponent.addStartEvent(this::beginContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
        super.addCanUseCheck(AbilityLimits::fruitless);
    }

    private void beginContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        CartStrongRightAbility cartStrongRightAbility = (CartStrongRightAbility)props.getEquippedAbility(CartStrongRightAbility.INSTANCE);
        IronBoxingAbility ironBoxingAbility = (IronBoxingAbility)props.getEquippedAbility(IronBoxingAbility.INSTANCE);
        if (cartStrongRightAbility != null) {
            cartStrongRightAbility.switchImpact(entity);
        }
        if (ironBoxingAbility != null) {
            ironBoxingAbility.switchImpact(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.func_70089_S()) {
            this.statsComponent.removeModifiers(entity);
        }
        if (AbilityLimits.ateFruit(entity, ability)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        CartStrongRightAbility cartStrongRightAbility = (CartStrongRightAbility)props.getEquippedAbility(CartStrongRightAbility.INSTANCE);
        IronBoxingAbility ironBoxingAbility = (IronBoxingAbility)props.getEquippedAbility(IronBoxingAbility.INSTANCE);
        if (cartStrongRightAbility != null) {
            cartStrongRightAbility.switchStrong(entity);
        }
        if (ironBoxingAbility != null) {
            ironBoxingAbility.switchStrong(entity);
        }
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous() && damage > 0.0f) {
            return damage * 0.65f;
        }
        return damage;
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.GENERAL_FRANKY.get();
    }

    public float getContinuityHoldTime() {
        return 2400.0f;
    }

    public float getCooldownTicks() {
        return 100.0f + this.continuousComponent.getContinueTime() / 6.0f;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        return props.isCyborg() && props.getDoriki() >= 3000.0;
    }
}

