/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.cybrogextra.CartStrongRightProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.cybrogextra.ImpactfulRightProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class CartStrongRightAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"strong_right", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user punches the opponent with an extensible ranged metal fist.", null), ImmutablePair.of((Object)"The user punches the opponent with a BIGGER extensible short range metal fist.", null)});
    private static final ResourceLocation STRONG_RIGHT = new ResourceLocation("cartaddon", "textures/abilities/strong_right.png");
    private static final ResourceLocation IMPACTFUL_RIGHT = new ResourceLocation("cartaddon", "textures/abilities/impactful_right.png");
    private static final TranslationTextComponent STRONG_RIGHT_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.strong_right", "Strong Right"));
    private static final TranslationTextComponent IMPACTFUL_RIGHT_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.impactful_right", "Impactful Right"));
    private static final float COOLDOWN = 100.0f;
    public static final AbilityCore<CartStrongRightAbility> INSTANCE = new AbilityCore.Builder("Strong Right", AbilityCategory.RACIAL, CartStrongRightAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> STRONG_RIGHT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)20.0f), CooldownComponent.getTooltip((float)100.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> IMPACTFUL_RIGHT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)100.0f)}).setSourceType(new SourceType[]{SourceType.FIST}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(CartStrongRightAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.STRONG, true).addChangeModeEvent(this::onAltModeChange);
    private boolean isShot;
    private AbilityProjectileEntity projectile;

    public CartStrongRightAbility(AbilityCore<CartStrongRightAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.altModeComponent});
        this.addCanUseCheck(BaraHelper::hasLimbs);
        this.addUseEvent(this::useEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.5f, 0.0f);
        this.projectile = this.projectileComponent.getShotProjectile();
        this.isShot = true;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 200, 0));
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private void tickEvent(LivingEntity entity, IAbility ability) {
        if (this.isShot) {
            if (this.projectile != null && !this.projectile.func_70089_S()) {
                this.projectile.func_70106_y();
                this.projectile = null;
            }
            entity.func_195063_d((Effect)ModEffects.NO_HANDS.get());
            this.isShot = false;
        }
    }

    public void switchStrong(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.STRONG);
    }

    public void switchImpact(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.IMPACTFUL);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.STRONG) {
            this.setDisplayIcon(STRONG_RIGHT);
            this.setDisplayName((ITextComponent)STRONG_RIGHT_NAME);
        } else if (mode == Mode.IMPACTFUL) {
            this.setDisplayIcon(IMPACTFUL_RIGHT);
            this.setDisplayName((ITextComponent)IMPACTFUL_RIGHT_NAME);
        }
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        AbilityProjectileEntity proj = new CartStrongRightProjectile(entity.field_70170_p, entity, this);
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACTFUL) {
            proj = new ImpactfulRightProjectile(entity.field_70170_p, entity, this);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isCyborg();
    }

    public static enum Mode {
        STRONG,
        IMPACTFUL;

    }
}

