/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.CyborgHelper;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.RadicalBeamProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CartRadicalBeamAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"radical_beam", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a powerful beam of energy at the opponent.", null)});
    private static final float CHARGE_TIME = 60.0f;
    private static final float COOLDOWN = 260.0f;
    private static final int COLA_REQUIRED = 30;
    public static final AbilityCore<CartRadicalBeamAbility> INSTANCE = new AbilityCore.Builder("Radical Beam", AbilityCategory.RACIAL, CartRadicalBeamAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)260.0f), ChargeComponent.getTooltip((float)60.0f), CyborgHelper.getColaTooltip((float)30.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHT).setUnlockCheck(CartRadicalBeamAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);

    public CartRadicalBeamAbility(AbilityCore<CartRadicalBeamAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.rangeComponent, this.chargeComponent, this.projectileComponent, this.animationComponent});
        this.addCanUseCheck(CyborgHelper.hasEnoughCola((int)30));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CHARGE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() == 39.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PRE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.CHARGE_RADICAL_BEAM.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)64.0);
        double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
        float damage = 0.0f;
        float size = 0.35f;
        float length = 50.0f;
        float extraY = 0.0f;
        if (MorphHelper.getZoanInfo((LivingEntity)entity) == CartMorphs.GENERAL_FRANKY.get()) {
            extraY = 3.0f;
        }
        Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)1.15, (double)0.8);
        LightningEntity bolt = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b + (double)extraY, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, 10.0f, this.getCore());
        bolt.setBlocksAffectedLimit(4000);
        bolt.setMaxLife(40);
        bolt.setDamage(damage);
        bolt.setExplosion(4, true);
        bolt.setSize(size);
        bolt.setBoxSizeDivision(1.0);
        bolt.setColor(ElThorAbility.YELLOW_THUNDER);
        bolt.setAngle(100);
        bolt.setTargetTimeToReset(60);
        bolt.disableExplosionKnockback();
        bolt.setBranches(1);
        bolt.setSegments(1);
        entity.field_70170_p.func_217376_c((Entity)bolt);
        props.alterCola(-30);
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo((Object)new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
        }
        float dmg = 65.0f;
        if (props.isSniper()) {
            dmg += 15.0f;
        }
        List list = this.rangeComponent.getTargetsInLine(entity, 64.0f, 2.5f);
        for (LivingEntity target : list) {
            target.func_70015_d(3);
            this.dealDamageComponent.hurtTarget(entity, target, dmg);
        }
        this.cooldownComponent.startCooldown(entity, 260.0f);
    }

    private RadicalBeamProjectile createProjectile(LivingEntity entity) {
        RadicalBeamProjectile proj = new RadicalBeamProjectile(entity.field_70170_p, entity);
        proj.setDamage(65.0f);
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        if (props.isSniper()) {
            proj.setDamage(80.0f);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isCyborg();
    }
}

