/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.cyborgextra;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.CyborgHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CartCoupDeBooAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"coup_de_boo", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches the user forward, causing all within the way to deal with the horrible smell.", null)});
    private static final float COOLDOWN = 120.0f;
    private static final int COLA_REQUIRED = 20;
    private static final int RANGE = 5;
    public static final AbilityCore<CartCoupDeBooAbility> INSTANCE = new AbilityCore.Builder("Coup De Boo", AbilityCategory.RACIAL, CartCoupDeBooAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)120.0f), CyborgHelper.getColaTooltip((float)20.0f), RangeComponent.getTooltip((float)5.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setUnlockCheck(CartCoupDeBooAbility::canUnlock).build();
    private final DamageTakenComponent damageTakenComponent;
    private final RangeComponent rangeComponent;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private boolean hasFallDamage = true;

    public CartCoupDeBooAbility(AbilityCore<CartCoupDeBooAbility> core) {
        super(core);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.rangeComponent = new RangeComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent, this.rangeComponent, this.continuousComponent});
        this.addCanUseCheck(CyborgHelper.hasEnoughCola((int)20));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(3.5);
        if (entity.func_233570_aj_() || entity.func_70090_H() || entity.func_180799_ab()) {
            look = entity.func_70040_Z().func_72432_b().func_186678_a(4.0);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)look);
        props.alterCola(-20);
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo((Object)new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.COUP_DE_BOO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        for (LivingEntity target : this.rangeComponent.getTargetsInArea(entity, 5.0f)) {
            target.func_195064_c(new EffectInstance(Effects.field_76436_u, 80, 1));
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.continuousComponent.getContinueTime() > 15.0f && entity.func_233570_aj_()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isCyborg();
    }
}

