/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.brawlerextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class ReworkedHakaiHoAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"hakai_ho", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user punches with enough force to create a small explosion damaging all nearby enemies.", null)});
    private static final int COOLDOWN = 240;
    private static final int RANGE = 2;
    private static final int DAMAGE = 40;
    public static final AbilityCore<ReworkedHakaiHoAbility> INSTANCE = new AbilityCore.Builder("Hakai Ho", AbilityCategory.STYLE, ReworkedHakaiHoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(ReworkedHakaiHoAbility::canUnlock).build();
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);

    public ReworkedHakaiHoAbility(AbilityCore<ReworkedHakaiHoAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.rangeComponent, this.dealDamageComponent});
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        List targets = this.rangeComponent.getTargetsInArea(entity, 2.0f);
        int ran = (int)(Math.random() * 100.0 + 1.0);
        targets.remove(entity);
        if (ran < 25) {
            AbilityHelper.setDeltaMovement((Entity)target, (double)0.0, (double)0.0, (double)0.0);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 12, 0, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 12, 0, false, false));
        }
        targets.remove(target);
        Vector3d dir = entity.func_70040_Z().func_216372_d(5.0, 0.0, 5.0);
        ModDamageSource newSource = ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).ignore();
        for (LivingEntity aoeTarget : targets) {
            if (!this.dealDamageComponent.hurtTarget(entity, aoeTarget, 40.0f, (DamageSource)newSource)) continue;
            if (ran < 25) {
                AbilityHelper.setDeltaMovement((Entity)aoeTarget, (double)0.0, (double)0.0, (double)0.0);
                aoeTarget.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 12, 0, false, false));
                aoeTarget.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 12, 0, false, false));
            } else {
                AbilityHelper.setDeltaMovement((Entity)aoeTarget, (Vector3d)aoeTarget.func_213322_ci().func_72441_c(dir.field_72450_a, 0.2, dir.field_72449_c));
            }
            aoeTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
        }
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_(), (float)2.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(false);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(2));
        explosion.setDamageEntities(false);
        explosion.doExplosion();
        AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        return true;
    }

    public boolean isParallel() {
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public float getPunchCooldown() {
        return 300.0f;
    }

    public float getPunchDamage() {
        return 40.0f;
    }

    public int getUseLimit() {
        return 1;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBrawler() && questProps.hasFinishedQuest(CartQuests.BRAWLER_TRIAL_04);
    }
}

