/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.brawlerextra;

import java.io.Serializable;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class ReworkedGenkotsuMeteorAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"genkotsu_meteor", (Pair[])new Pair[]{ImmutablePair.of((Object)"Throws a cannon ball from the user's hand or multiple cannon balls in \u00a7aRyuseigun\u00a7r mode", null)});
    private static final TranslationTextComponent GENKOTSU_MODE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.genkotsu_meteor", (String)"Genkotsu Meteor"));
    private static final TranslationTextComponent RYUSEIGUN_MODE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.genkotsu_meteor_ryuseigun", (String)"Ryuseigun"));
    private static final ResourceLocation GENKOTSU_METEOR_NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/genkotsu_meteor.png");
    private static final ResourceLocation GENKOTSU_METEOR_RYUSEIGUN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/genkotsu_meteor_ryuseigun.png");
    private static final float NORMAL_COOLDOWN = 60.0f;
    private static final float RYUSEIGUN_COOLDOWN = 240.0f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<ReworkedGenkotsuMeteorAbility> INSTANCE = new AbilityCore.Builder("Genkotsu Meteor", AbilityCategory.STYLE, ReworkedGenkotsuMeteorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> GENKOTSU_MODE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), CooldownComponent.getTooltip((float)60.0f), DealDamageComponent.getTooltip((float)30.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> RYUSEIGUN_MODE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), CooldownComponent.getTooltip((float)240.0f), DealDamageComponent.getTooltip((float)15.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.INDIRECT}).setUnlockCheck(ReworkedGenkotsuMeteorAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NORMAL).addChangeModeEvent(this::onAltModeChange);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private ItemStack cannonBalls = null;

    public ReworkedGenkotsuMeteorAbility(AbilityCore<ReworkedGenkotsuMeteorAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.repeaterComponent, this.altModeComponent, this.projectileComponent});
        this.addCanUseCheck(this::canUseAbility);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
                if (!itemStack.func_77973_b().equals(ModItems.CANNON_BALL.get())) continue;
                this.cannonBalls = itemStack;
                break;
            }
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
                this.repeaterComponent.start(entity, 1, 1);
            } else if (this.altModeComponent.getCurrentMode() == Mode.RYUSEIGUN) {
                this.repeaterComponent.start(entity, 8, 4);
            }
        }
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (this.cannonBalls != null && this.cannonBalls.func_190916_E() != 0 && !this.canUseAbility(entity, ability).isFail()) {
            this.cannonBalls.func_190918_g(1);
            float inaccuracy = this.altModeComponent.getCurrentMode() == Mode.NORMAL ? 0.0f : 2.0f;
            this.projectileComponent.shoot(entity, 3.0f, inaccuracy);
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
        } else {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST_OR_CANNONBALLS), Util.field_240973_b_);
            this.repeaterComponent.stop(entity);
        }
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
            this.cooldownComponent.startCooldown(entity, 60.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.RYUSEIGUN) {
            this.cooldownComponent.startCooldown(entity, 240.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NORMAL) {
            super.setDisplayIcon(GENKOTSU_METEOR_NORMAL_ICON);
        } else if (mode == Mode.RYUSEIGUN) {
            super.setDisplayIcon(GENKOTSU_METEOR_RYUSEIGUN_ICON);
        }
    }

    private CannonBallProjectile createProjectile(LivingEntity entity) {
        CannonBallProjectile proj = new CannonBallProjectile(entity.field_70170_p, entity, INSTANCE);
        proj.setDamage(15.0f);
        if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
            proj.setDamage(30.0f);
        }
        proj.onEntityImpactEvent = (AbilityProjectileEntity.IOnEntityImpact & Serializable)hit -> {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj.getThrower(), (World)entity.field_70170_p, (double)hit.func_226277_ct_(), (double)hit.func_226278_cu_(), (double)hit.func_226281_cx_(), (float)1.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        proj.onBlockImpactEvent = (AbilityProjectileEntity.IOnBlockImpact & Serializable)hit -> {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj.getThrower(), (World)entity.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), (float)1.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        return proj;
    }

    private AbilityUseResult canUseAbility(LivingEntity entity, IAbility ability) {
        return (!entity.func_184614_ca().func_190926_b() || ItemsHelper.countItemInInventory((LivingEntity)entity, (Item)((Item)ModItems.CANNON_BALL.get())) <= 0) && !entity.func_184614_ca().func_77973_b().equals(ModItems.CANNON_BALL.get()) ? AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST_OR_CANNONBALLS)) : AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBrawler() && questProps.hasFinishedQuest(CartQuests.BRAWLER_TRIAL_03);
    }

    public static enum Mode {
        NORMAL,
        RYUSEIGUN;

    }
}

