/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.brawlerextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.brawlerextra.QueenPunchProjectile;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.brawler.KingPunchChargeParticleEffect;

public class QueenPunchAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"queen_punch", (Pair[])new Pair[]{ImmutablePair.of((Object)"A punch of exceptionally concentrated strength, capable of releasing an immense amount of air pressure, but needs time to fully charge.", null)});
    private static final KingPunchChargeParticleEffect PARTICLES = new KingPunchChargeParticleEffect();
    private static final int CHARGE_TIME = 100;
    private static final float MIN_COOLDOWN = 200.0f;
    private static final float MAX_COOLDOWN = 600.0f;
    private static final float MIN_DAMAGE = 40.0f;
    private static final float MAX_DAMAGE = 80.0f;
    public static final AbilityCore<QueenPunchAbility> INSTANCE = new AbilityCore.Builder("Queen Punch", AbilityCategory.STYLE, QueenPunchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)65.0f), ChargeComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)200.0f, (float)600.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(QueenPunchAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> comp.getChargePercentage() > 0.2f).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::duringChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private boolean cancelled = false;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public QueenPunchAbility(AbilityCore<QueenPunchAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.dealDamageComponent});
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 100.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        this.cancelled = false;
    }

    private void duringChargingEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70172_ad > 0) {
            this.cancelled = true;
            this.chargeComponent.stopCharging(entity);
        } else {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
            if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
                PARTICLES.spawn(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        if (!this.cancelled) {
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            float chargeTime = this.chargeComponent.getChargeTime();
            QueenPunchProjectile proj = new QueenPunchProjectile(entity.field_70170_p, entity);
            proj.setDamage(65.0f);
            proj.setLife((int)proj.getDamage() / 2);
            entity.field_70170_p.func_217376_c((Entity)proj);
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 1.25f, 1.0f);
            entity.func_195063_d((Effect)ModEffects.MOVEMENT_BLOCKED.get());
            this.cooldownComponent.startCooldown(entity, chargeTime * 4.0f + 200.0f);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBrawler() && questProps.hasFinishedQuest(CartQuests.BRAWLER_TRIAL_06);
    }
}

