/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.brawlerextra;

import java.awt.Color;
import java.util.UUID;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.brawlerextra.GalaxyDivideProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.brawlerextra.GalaxyImpactProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GalaxyImpactAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"galaxy_impact", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user jumps up and charges a large shockwave of haki that brings only destruction upon those below them.", null), ImmutablePair.of((Object)"The user charges a blast of haki and moves at immense speeds.", null)});
    private static final TranslationTextComponent IMPACT_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.galaxy_impact", "Galaxy Impact"));
    private static final TranslationTextComponent DIVIDE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.galaxy_divide", "Galaxy Divide"));
    private static final ResourceLocation IMPACT_ICON = new ResourceLocation("cartaddon", "textures/abilities/galaxy_impact.png");
    private static final ResourceLocation DIVIDE_ICON = new ResourceLocation("cartaddon", "textures/abilities/galaxy_divide.png");
    private static final float G_IMPACT_COOLDOWN = 1800.0f;
    private static final float G_CHARGE = 60.0f;
    private static final float G_IMPACT_DURATION = 60.0f;
    private static final float G_DIVIDE_COOLDOWN = 1800.0f;
    private static final float G_DIVIDE_CHARGE = 60.0f;
    private static final float G_DIVIDE_DURATION = 80.0f;
    public static final AbilityCore<GalaxyImpactAbility> INSTANCE;
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    boolean hasFallDamage;
    private SphereEntity galaxyImpactVisuals;
    private GalaxyImpactProjectile proj;
    private BlockPos blockPos;
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.IMPACT).addChangeModeEvent(this::onAltModeChange);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private static final AbilityAttributeModifier SPEED_MODIFIER;
    private static final AbilityAttributeModifier JUMP_MODIFIER;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.INIT_JUMP, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
    private boolean prevSprintValue;
    public static int overuse;
    private LightningDischargeEntity discharge;
    private Color color = new Color(35, 175, 255, 200);
    private int radius = 0;
    private int haoMastery = 0;

    public GalaxyImpactAbility(AbilityCore<GalaxyImpactAbility> core) {
        super(core);
        this.isNew = true;
        this.hasFallDamage = true;
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.JUMP_HEIGHT.get(), (AttributeModifier)JUMP_MODIFIER);
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.statsComponent, this.damageTakenComponent, this.altModeComponent, this.continuousComponent, this.chargeComponent, this.projectileComponent, this.animationComponent});
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        this.addCanUseCheck(AbilityLimits::fruitless);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            boolean isOnMaxOveruse;
            if (!HakiHelper.hasInfusionActive((LivingEntity)entity) && entity instanceof PlayerEntity) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("You need to activate Hao Infusion to use this move!"), entity.func_110124_au());
                return;
            }
            if (!WyHelper.isInChallengeDimension((World)entity.field_70170_p) && (isOnMaxOveruse = HakiHelper.checkForHakiOveruse((LivingEntity)entity, (int)overuse))) {
                return;
            }
            if (this.altModeComponent.getCurrentMode() == Mode.IMPACT) {
                this.chargeComponent.startCharging(entity, 60.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.DIVIDE) {
                this.chargeComponent.startCharging(entity, 60.0f);
            }
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACT) {
            this.hasFallDamage = false;
            this.galaxyImpactVisuals = null;
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)4.0, (double)entity.func_213322_ci().field_72449_c);
            this.animationComponent.start(entity, ModAnimations.CHARGE_PUNCH);
        }
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
        float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
        if (haoLevel <= 1.0f) {
            this.radius = 10;
            this.haoMastery = 0;
        } else if (haoLevel > 1.0f && haoLevel <= 1.75f) {
            this.radius = 25;
            this.haoMastery = 1;
        } else if (haoLevel > 1.75f) {
            this.radius = 40;
            this.haoMastery = 2;
        }
        if (entity instanceof PlayerEntity) {
            this.color = new Color(HakiHelper.getHaoshokuColour((LivingEntity)entity));
        }
        this.discharge = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        this.discharge.setAliveTicks(-1);
        this.discharge.setUpdateRate(8);
        this.discharge.setLightningLength((float)(this.radius * 2));
        this.discharge.setColor(new Color(0, 0, 0, 100));
        this.discharge.setOutlineColor(this.color);
        this.discharge.setRenderTransparent();
        this.discharge.setDetails(16);
        int density = this.haoMastery == 2 ? 32 : 16;
        this.discharge.setDensity(density);
        this.discharge.setSize(1.0f);
        this.discharge.setSkipSegments(1);
        if (this.haoMastery == 0) {
            this.discharge.setSplit();
        }
        if (entity instanceof PlayerEntity) {
            entity.field_70170_p.func_217376_c((Entity)this.discharge);
            if (this.discharge != null) {
                this.discharge.setAliveTicks(80);
            }
        }
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACT) {
            AbilityHelper.slowEntityFall((LivingEntity)entity);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.DIVIDE) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d.getEffect(), 2, 2, false, false));
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.5);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        if (this.chargeComponent.getChargeTime() > 40.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.GALAXY_IMPACT.get()), (Entity)entity, (double)i, (double)j, (double)k);
        }
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            this.discharge.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        }
        if (this.discharge != null && !entity.func_70089_S()) {
            this.discharge.setAliveTicks(0);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACT) {
            if (this.discharge != null) {
                this.discharge.setAliveTicks(30);
            }
            this.proj = new GalaxyImpactProjectile(entity.field_70170_p, entity);
            entity.field_70170_p.func_217376_c((Entity)this.proj);
            this.proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 0.0f, 0.0f);
            this.proj.setSize(15.0f);
            this.blockPos = new BlockPos(entity.func_226277_ct_(), DevilFruitHelper.getFloorLevel((Entity)entity).field_72448_b, entity.func_226281_cx_());
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            this.animationComponent.stop(entity);
            this.continuousComponent.startContinuity(entity, 60.0f);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.DIVIDE) {
            this.continuousComponent.startContinuity(entity, 60.0f);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.DIVIDE) {
            this.statsComponent.applyModifiers(entity);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACT) {
            if (this.galaxyImpactVisuals == null && this.proj.isFinished()) {
                this.galaxyImpactVisuals = new SphereEntity(entity.field_70170_p, entity);
                Color col = WyHelper.intToRGB((int)HakiHelper.getHaoshokuColour((LivingEntity)entity), (int)200);
                if (!(entity instanceof PlayerEntity)) {
                    col = new Color(35, 175, 255, 200);
                }
                this.galaxyImpactVisuals.func_184195_f(true);
                this.galaxyImpactVisuals.setColor(col);
                this.galaxyImpactVisuals.setRadius(35.0f);
                this.galaxyImpactVisuals.setDetailLevel(32);
                this.galaxyImpactVisuals.setAnimationSpeed(1);
                this.galaxyImpactVisuals.func_70107_b((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p());
                entity.field_70170_p.func_217376_c((Entity)this.galaxyImpactVisuals);
            }
            this.galaxyImpactVisuals.setRadius(this.galaxyImpactVisuals.getRadius() + 0.2f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.DIVIDE) {
            if (this.discharge != null && !entity.func_70089_S()) {
                this.discharge.setAliveTicks(0);
            }
            if (this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
                this.discharge.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
            }
            if (this.continuousComponent.getContinueTime() % 10.0f == 0.0f) {
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
            }
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.5);
            double i = mop.func_216347_e().field_72450_a;
            double j = mop.func_216347_e().field_72448_b;
            double k = mop.func_216347_e().field_72449_c;
            if (this.chargeComponent.getChargeTime() > 40.0f) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.GALAXY_IMPACT.get()), (Entity)entity, (double)i, (double)j, (double)k);
            }
            if (entity.field_82175_bq) {
                this.continuousComponent.stopContinuity(entity);
            }
            if (AbilityHelper.canUseMomentumAbilities((LivingEntity)entity)) {
                if (entity.func_70051_ag()) {
                    if (!this.prevSprintValue) {
                        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.8f);
                    }
                    float maxSpeed = 4.0f;
                    Vector3d vec = entity.func_70040_Z();
                    if (entity.func_233570_aj_()) {
                        double xDir = vec.field_72450_a * (double)maxSpeed;
                        double zDir = vec.field_72449_c * (double)maxSpeed;
                        AbilityHelper.setDeltaMovement((Entity)entity, (double)xDir, (double)entity.func_213322_ci().field_72448_b, (double)zDir);
                    } else {
                        double xDir = vec.field_72450_a * (double)maxSpeed * 0.5;
                        double zDir = vec.field_72449_c * (double)maxSpeed;
                        AbilityHelper.setDeltaMovement((Entity)entity, (double)xDir, (double)entity.func_213322_ci().field_72448_b, (double)(zDir * 0.5));
                    }
                    this.prevSprintValue = entity.func_70051_ag();
                } else {
                    this.prevSprintValue = false;
                }
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.IMPACT) {
            if (this.galaxyImpactVisuals != null) {
                this.galaxyImpactVisuals.func_70106_y();
            }
            this.cooldownComponent.startCooldown(entity, 1800.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.DIVIDE) {
            if (this.discharge != null) {
                this.discharge.setAliveTicks(30);
            }
            this.statsComponent.removeModifiers(entity);
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            this.projectileComponent.shoot(entity, 3.75f, 1.0f);
            this.cooldownComponent.startCooldown(entity, 1800.0f);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        AbilityProjectileEntity projectile = this.altModeComponent.getCurrentMode() == Mode.IMPACT ? new GalaxyImpactProjectile(entity.field_70170_p, entity) : new GalaxyDivideProjectile(entity.field_70170_p, entity);
        return projectile;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            if (mode == Mode.IMPACT) {
                this.setDisplayIcon(IMPACT_ICON);
                this.setDisplayName((ITextComponent)IMPACT_NAME);
            } else if (mode == Mode.DIVIDE) {
                this.setDisplayIcon(DIVIDE_ICON);
                this.setDisplayName((ITextComponent)DIVIDE_NAME);
            }
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBrawler() && questProps.hasFinishedQuest(CartQuests.BRAWLER_TRIAL_08);
    }

    static {
        overuse = 1500;
        INSTANCE = new AbilityCore.Builder("Galaxy Impact", AbilityCategory.STYLE, GalaxyImpactAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> IMPACT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)60.0f), ChargeComponent.getTooltip((float)80.0f), CooldownComponent.getTooltip((float)1800.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> DIVIDE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)90.0f), ChargeComponent.getTooltip((float)60.0f), ContinuousComponent.getTooltip((float)80.0f), CooldownComponent.getTooltip((float)1800.0f), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(GalaxyImpactAbility::canUnlock).build();
        SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("83979d24-62a4-4014-b1db-44e22a641511"), INSTANCE, "Galaxy Divide Modifier", 0.02, AttributeModifier.Operation.ADDITION);
        JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("b07997f2-d0a2-4a98-a083-f2f237cb7b4e"), INSTANCE, "Galaxy Divide Jump Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    }

    public static enum Mode {
        IMPACT,
        DIVIDE;

    }
}

