/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.brawlerextra;

import java.awt.Color;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.particles.effects.brawler.BlueHoleParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlueHoleAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"blue_hole", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user dashes forward and grabs a nearby target, jumping higher into the air and launches them into the ground.", null)});
    private static final int COOLDOWN = 600;
    private static final int HOLD_TIME = 80;
    private static final float RANGE = 1.4f;
    public static final BlueHoleParticleEffect PARTICLES = new BlueHoleParticleEffect();
    public static final AbilityCore<BlueHoleAbility> INSTANCE;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final GrabEntityComponent grabEntityComponent;
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.INIT_JUMP, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    LivingEntity target;
    boolean hasFallDamage = false;
    public static int overuse;
    private LightningDischargeEntity discharge;
    private Color color = new Color(35, 175, 255, 200);
    private int radius = 0;
    private int haoMastery = 0;

    public BlueHoleAbility(AbilityCore<BlueHoleAbility> core) {
        super(core);
        this.grabEntityComponent = new GrabEntityComponent((IAbility)this, false, true, 1.0f);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.damageTakenComponent, this.hitTrackerComponent, this.chargeComponent, this.poolComponent, this.dealDamageComponent, this.continuousComponent, this.rangeComponent, this.grabEntityComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        super.addCanUseCheck(AbilityLimits::fruitless);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        boolean isOnMaxOveruse;
        if (!HakiHelper.hasInfusionActive((LivingEntity)entity) && entity instanceof PlayerEntity) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need to activate Hao Infusion to use this move!"), entity.func_110124_au());
            return;
        }
        if (!WyHelper.isInChallengeDimension((World)entity.field_70170_p) && (isOnMaxOveruse = HakiHelper.checkForHakiOveruse((LivingEntity)entity, (int)overuse))) {
            return;
        }
        if (!this.continuousComponent.isContinuous() && !this.chargeComponent.isCharging()) {
            this.continuousComponent.triggerContinuity(entity, 30.0f);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        if (!entity.field_70170_p.field_72995_K) {
            if (this.target != null) {
                this.target = null;
            }
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(4.0, 0.0, 4.0).func_72441_c(0.0, 0.4, 0.0);
            AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)speed);
        }
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
        float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
        if (haoLevel <= 1.0f) {
            this.radius = 10;
            this.haoMastery = 0;
        } else if (haoLevel > 1.0f && haoLevel <= 1.75f) {
            this.radius = 25;
            this.haoMastery = 1;
        } else if (haoLevel > 1.75f) {
            this.radius = 40;
            this.haoMastery = 2;
        }
        if (entity instanceof PlayerEntity) {
            this.color = new Color(HakiHelper.getHaoshokuColour((LivingEntity)entity));
        }
        this.discharge = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        this.discharge.setAliveTicks(-1);
        this.discharge.setUpdateRate(8);
        this.discharge.setLightningLength((float)(this.radius * 2));
        this.discharge.setColor(new Color(0, 0, 0, 100));
        this.discharge.setOutlineColor(this.color);
        this.discharge.setRenderTransparent();
        this.discharge.setDetails(16);
        int density = this.haoMastery == 2 ? 32 : 16;
        this.discharge.setDensity(density);
        this.discharge.setSize(1.0f);
        this.discharge.setSkipSegments(1);
        if (this.haoMastery == 0) {
            this.discharge.setSplit();
        }
        if (entity instanceof PlayerEntity) {
            entity.field_70170_p.func_217376_c((Entity)this.discharge);
            if (this.discharge != null) {
                this.discharge.setAliveTicks(40);
            }
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            LivingEntity grabbedTarget = this.grabEntityComponent.getGrabbedEntity();
            if (!super.canUse(entity).isFail() && (grabbedTarget == null || this.grabEntityComponent.canContinueGrab(entity))) {
                if (grabbedTarget == null) {
                    this.grabEntityComponent.grabNearest(entity, 2.5f, 2.0f, false);
                }
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
            if (this.grabEntityComponent.hasGrabbedEntity()) {
                this.continuousComponent.stopContinuity(entity);
            }
        }
        if (this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            this.discharge.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if (this.continuousComponent.getContinueTime() % 10.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (this.discharge != null) {
            this.discharge.setAliveTicks(30);
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabEntityComponent.hasGrabbedEntity()) {
                this.chargeComponent.startCharging(entity, 30.0f);
            } else {
                this.grabEntityComponent.release(entity);
                if (entity instanceof PlayerEntity) {
                    this.cooldownComponent.startCooldown(entity, 600.0f);
                } else {
                    this.cooldownComponent.startCooldown(entity, 300.0f);
                }
            }
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)3.0, (double)entity.func_213322_ci().field_72449_c);
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        if (this.grabEntityComponent.hasGrabbedEntity() && this.chargeComponent.getChargeTime() > 20.0f) {
            this.target = this.grabEntityComponent.getGrabbedEntity();
            this.grabEntityComponent.release(entity);
            Vector3d look = entity.func_70040_Z().func_216372_d(4.0, 4.0, 4.0).func_72441_c(0.0, -30.0, 0.0);
            AbilityHelper.setDeltaMovement((Entity)this.target, (Vector3d)look);
        }
        if (this.target != null) {
            this.dealDamageComponent.hurtTarget(entity, this.target, 10.0f);
            this.target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0, false, false));
            this.target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0, false, false));
            this.target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 20, 0, false, false));
            if (this.target.func_233570_aj_() && this.hitTrackerComponent.canHit((Entity)this.target)) {
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)this.target.func_226277_ct_(), (double)this.target.func_226278_cu_(), (double)this.target.func_226281_cx_(), (float)8.0f);
                explosion.setStaticDamage(3.0f);
                explosion.doExplosion();
                this.dealDamageComponent.hurtTarget(entity, this.target, 40.0f);
                PARTICLES.spawn((Entity)entity, entity.field_70170_p, this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_(), 60.0, -90.0f, 0.0f);
                if (!entity.field_70170_p.field_72995_K) {
                    ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
                }
            }
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.target = null;
        if (entity instanceof PlayerEntity) {
            this.cooldownComponent.startCooldown(entity, 600.0f);
        } else {
            this.cooldownComponent.startCooldown(entity, 300.0f);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBrawler() && questProps.hasFinishedQuest(CartQuests.BRAWLER_TRIAL_07);
    }

    static {
        overuse = 100;
        INSTANCE = new AbilityCore.Builder("Blue Hole", AbilityCategory.STYLE, BlueHoleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)10.0f, (float)50.0f), ChargeComponent.getTooltip((float)30.0f), ContinuousComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)600.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(BlueHoleAbility::canUnlock).build();
    }
}

