/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bludgeon;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.HandSide;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.GroundParticlesEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class StrikingSwingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"striking_swing", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and swings their mace, stunning nearby enemies.", null)});
    public static final ParticleEffect PARTICLES = new GroundParticlesEffect(5, 100);
    private static final float COOLDOWN = 200.0f;
    private static final float DAMAGE = 30.0f;
    private static final float RANGE = 4.5f;
    public static final AbilityCore<StrikingSwingAbility> INSTANCE = new AbilityCore.Builder("Striking Swing", AbilityCategory.STYLE, StrikingSwingAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)30.0f), ChargeComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)4.5f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceElement(SourceElement.SHOCKWAVE).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(StrikingSwingAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private boolean forcedStop = false;

    public StrikingSwingAbility(AbilityCore<StrikingSwingAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent, this.continuousComponent, this.dealDamageComponent, this.rangeComponent});
        this.addCanUseCheck(AbilityLimits::requiresBluntWeapon);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (entity.func_184591_cq() == HandSide.RIGHT) {
                this.animationComponent.start(entity, CartAnimations.STRIKING_SWING_RIGHT, 10);
            }
            if (entity.func_184591_cq() == HandSide.LEFT) {
                this.animationComponent.start(entity, CartAnimations.STRIKING_SWING_LEFT, 10);
            }
            this.chargeComponent.startCharging(entity, 9.0f);
            this.forcedStop = false;
        }
    }

    private void startChargeEvent(LivingEntity player, IAbility ability) {
    }

    private void tickChargeEvent(LivingEntity player, IAbility ability) {
        if (!AbilityLimits.canUseBlunt(player)) {
            this.chargeComponent.stopCharging(player);
            this.forcedStop = true;
        }
    }

    private void endChargeEvent(LivingEntity player, IAbility ability) {
        if (!this.forcedStop) {
            ItemStack stack = player.func_184614_ca();
            stack.func_222118_a(1, player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            if (!player.field_70170_p.field_72995_K) {
                ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            }
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            List targets = this.rangeComponent.getTargetsInArea(player, 4.5f);
            targets.remove(player);
            targets.removeIf(entity -> !entity.func_233570_aj_() && DevilFruitHelper.getDifferenceToFloor((Entity)player) > 2.5);
            for (LivingEntity target : targets) {
                this.dealDamageComponent.hurtTarget(player, target, 30.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 40, 0, false, false));
            }
        }
        this.cooldownComponent.startCooldown(player, 200.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.BLUDGEON) && questProps.hasFinishedQuest(CartQuests.BLUDGEON_TRIAL_01);
    }
}

