/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bludgeon;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.bludgeon.ShinsokuHakujakuProjectile;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShinsokuHakujakuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"shinsoku_hakujaku", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user dashes and drags nearby targets. At the end of this ability, the user fires a White Serpent that applies dizzy and knockback. (Fruitless)", null)});
    private static final float COOLDOWN = 800.0f;
    private static final float RANGE = 20.0f;
    private static final float DMG = 40.0f;
    private static final float CHARGE_TIME = 55.0f;
    public static final AbilityCore<ShinsokuHakujakuAbility> INSTANCE = new AbilityCore.Builder("Shinsoku Hakujaku", AbilityCategory.STYLE, ShinsokuHakujakuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)40.0f), ChargeComponent.getTooltip((float)55.0f), CooldownComponent.getTooltip((float)900.0f), RangeComponent.getTooltip((float)20.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceElement(SourceElement.SHOCKWAVE).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(ShinsokuHakujakuAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public ShinsokuHakujakuAbility(AbilityCore<ShinsokuHakujakuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.dealDamageComponent, this.rangeComponent, this.hitTrackerComponent, this.projectileComponent, this.animationComponent, this.chargeComponent});
        this.addCanUseCheck(AbilityLimits::requiresBluntWeapon);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        this.addCanUseCheck(AbilityLimits::fruitless);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 55.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, CartAnimations.WHITE_SERPENT_RIGHT);
        } else {
            this.animationComponent.start(entity, CartAnimations.WHITE_SERPENT_LEFT);
        }
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.WHITE_SERPENT.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 0, false, false));
        if (!AbilityLimits.canUseBlunt(entity)) {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.canUseBlunt(entity) && this.chargeComponent.getChargeTime() == 55.0f) {
            ItemStack stack = entity.func_184614_ca();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            BlockPos blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)20.0f);
            AbilityDamageSource source = (AbilityDamageSource)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash();
            Vector3d startPos = entity.func_213303_ch();
            float actualTeleportDistance = 20.0f;
            for (double f = 0.0; f < 1.0; f += 0.13) {
                double z;
                double y;
                double x = MathHelper.func_219803_d((double)f, (double)startPos.func_82615_a(), (double)blockpos.func_177958_n());
                Vector3d pos = new Vector3d(x, y = MathHelper.func_219803_d((double)f, (double)startPos.func_82617_b(), (double)blockpos.func_177956_o()), z = MathHelper.func_219803_d((double)f, (double)startPos.func_82616_c(), (double)blockpos.func_177952_p()));
                List projectiles = WyHelper.getNearbyEntities((Vector3d)pos, (IWorld)entity.field_70170_p, (double)entity.func_213311_cf(), (double)entity.func_213302_cg(), (double)entity.func_213311_cf(), (Predicate)null, (Class[])new Class[]{ProjectileEntity.class});
                if (projectiles.isEmpty()) continue;
                projectiles.sort(TargetHelper.closestComparator((Vector3d)startPos));
                actualTeleportDistance = MathHelper.func_76133_a((double)((ProjectileEntity)projectiles.get(0)).func_195048_a(startPos));
                break;
            }
            blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)actualTeleportDistance);
            List targets = this.rangeComponent.getTargetsInLine(entity, actualTeleportDistance, 2.5f);
            for (LivingEntity target : targets) {
                boolean flag;
                if (!this.hitTrackerComponent.canHit((Entity)target) || !(flag = this.dealDamageComponent.hurtTarget(entity, target, 40.0f, (DamageSource)source)) || entity.field_70170_p.field_72995_K) continue;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)target.func_70047_e()), (double)target.func_226281_cx_());
                target.func_184210_p();
                target.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            }
            entity.func_184210_p();
            entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.7f);
            this.projectileComponent.shoot(entity, 5.0f, 0.0f);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 900.0f);
    }

    private ShinsokuHakujakuProjectile createProjectile(LivingEntity entity) {
        ShinsokuHakujakuProjectile proj = new ShinsokuHakujakuProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.BLUDGEON) && questProps.hasFinishedQuest(CartQuests.BLUDGEON_TRIAL_08);
    }
}

