/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bludgeon;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.bludgeon.KundaliDragonSwarmProjectile;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class KundaliDragonSwarmAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kundali_dragon_swarm", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user lets out a barrage of their blunt weapon, stunning all those that oppose them.", null)});
    private static final float COOLDOWN = 240.0f;
    public static final AbilityCore<KundaliDragonSwarmAbility> INSTANCE = new AbilityCore.Builder("Kundali Dragon Swarm", AbilityCategory.STYLE, KundaliDragonSwarmAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(KundaliDragonSwarmAbility::canUnlock).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private float cooldown;
    private int triggers;
    private int interval;

    public KundaliDragonSwarmAbility(AbilityCore<KundaliDragonSwarmAbility> core) {
        super(core);
        this.isNew = true;
        this.cooldown = 240.0f;
        this.triggers = 9;
        this.interval = 7;
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 3; ++i) {
                this.projectileComponent.shootWithSpread(living, 2.0f, 0.25f, 2);
            }
        });
        super.addComponents(new AbilityComponent[]{this.animationComponent});
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
        super.addCanUseCheck(AbilityLimits::requiresBluntWeapon);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        if (!AbilityLimits.canUseBlunt(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.repeaterComponent.stop(entity);
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        KundaliDragonSwarmProjectile projectile = new KundaliDragonSwarmProjectile(entity.field_70170_p, entity);
        Vector3d look = entity.func_70040_Z();
        projectile.field_70125_A = (float)look.field_72450_a;
        projectile.field_70177_z = (float)look.field_72448_b;
        return projectile;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.BLUDGEON) && questProps.hasFinishedQuest(CartQuests.BLUDGEON_TRIAL_04);
    }
}

