/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bludgeon;

import java.awt.Color;
import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DestroyerOfDeathThunderBaguaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"destroyer_of_death_thunder_bagua", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user rushes towards their target, dealing massive damage. Applies dizzy, and knocks the opponent downwards. (Fruitless)", null)});
    private static final int HOLD_TIME = 15;
    private static final int COOLDOWN = 900;
    private static final float DAMAGE = 110.0f;
    public static final AbilityCore<DestroyerOfDeathThunderBaguaAbility> INSTANCE;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private boolean hasFallDamage;
    public static int overuse;
    private LightningDischargeEntity discharge;
    private Color color = new Color(0xFF0000);
    private int radius = 0;
    private int haoMastery = 0;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public DestroyerOfDeathThunderBaguaAbility(AbilityCore<DestroyerOfDeathThunderBaguaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.damageTakenComponent, this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityLimits::requiresBluntWeapon);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        this.addCanUseCheck(AbilityLimits::fruitless);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        boolean isOnMaxOveruse;
        if (!HakiHelper.hasInfusionActive((LivingEntity)entity) && entity instanceof PlayerEntity) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need to activate Hao Infusion to use this move!"), entity.func_110124_au());
            return;
        }
        if (!WyHelper.isInChallengeDimension((World)entity.field_70170_p) && (isOnMaxOveruse = HakiHelper.checkForHakiOveruse((LivingEntity)entity, (int)overuse))) {
            return;
        }
        if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 15.0f);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
        float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
        if (haoLevel <= 1.0f) {
            this.radius = 10;
            this.haoMastery = 0;
        } else if (haoLevel > 1.0f && haoLevel <= 1.75f) {
            this.radius = 25;
            this.haoMastery = 1;
        } else if (haoLevel > 1.75f) {
            this.radius = 40;
            this.haoMastery = 2;
        }
        if (entity instanceof PlayerEntity) {
            this.color = new Color(HakiHelper.getHaoshokuColour((LivingEntity)entity));
        }
        this.discharge = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        this.discharge.setAliveTicks(-1);
        this.discharge.setUpdateRate(8);
        this.discharge.setLightningLength((float)(this.radius * 2));
        this.discharge.setColor(new Color(0, 0, 0, 100));
        this.discharge.setOutlineColor(this.color);
        this.discharge.setRenderTransparent();
        this.discharge.setDetails(16);
        int density = this.haoMastery == 2 ? 32 : 16;
        this.discharge.setDensity(density);
        this.discharge.setSize(1.0f);
        this.discharge.setSkipSegments(1);
        if (this.haoMastery == 0) {
            this.discharge.setSplit();
        }
        if (entity instanceof PlayerEntity) {
            entity.field_70170_p.func_217376_c((Entity)this.discharge);
            if (this.discharge != null) {
                this.discharge.setAliveTicks(40);
            }
        }
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d.getEffect(), 2, 1, false, false));
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            this.discharge.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        }
        if (this.discharge != null && !entity.func_70089_S()) {
            this.discharge.setAliveTicks(0);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.discharge != null) {
            this.discharge.setAliveTicks(30);
        }
        this.continuousComponent.startContinuity(entity, 12.5f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        this.hitTrackerComponent.clearHits();
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, CartAnimations.DESTROYER_OF_DEATH_RIGHT);
        } else if (entity.func_184591_cq() == HandSide.LEFT) {
            this.animationComponent.start(entity, CartAnimations.DESTROYER_OF_DEATH_LEFT);
        }
        Vector3d look = entity.func_70040_Z().func_72432_b();
        Vector3d speed = look.func_186678_a(entity.func_233570_aj_() ? 6.0 : 5.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)speed.field_72448_b, (double)speed.field_72449_c);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            List targets = this.rangeComponent.getTargetsInArea(entity, 2.0f);
            for (LivingEntity target : targets) {
                AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
                source.setUnavoidable();
                if (this.hitTrackerComponent.canHit((Entity)target) && this.dealDamageComponent.hurtTarget(entity, target, 110.0f, (DamageSource)source)) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0, false, false));
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 20, 0, false, false, true));
                }
                AbilityHelper.setDeltaMovement((Entity)target, (double)entity.func_213322_ci().field_72450_a, (double)-6.0, (double)entity.func_213322_ci().field_72450_a);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 900.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.BLUDGEON) && questProps.hasFinishedQuest(CartQuests.BLUDGEON_TRIAL_07);
    }

    static {
        overuse = 1250;
        INSTANCE = new AbilityCore.Builder("Destroyer of Death Thunder Bagua", AbilityCategory.STYLE, DestroyerOfDeathThunderBaguaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)15.0f), ContinuousComponent.getTooltip((float)12.5f), DealDamageComponent.getTooltip((float)110.0f), CooldownComponent.getTooltip((float)900.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(DestroyerOfDeathThunderBaguaAbility::canUnlock).build();
    }
}

