/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bludgeon;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.oni.OniHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ConquerorOfThreeWorldsRagnarakuAbility
extends DropHitAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"conqueror_of_three_worlds_ragnaraku", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user leaps into the air, and delivers a devastating slam. (With \u00a7aOni Awakening\u00a7r knocks out opponents)", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    public static final AbilityCore<ConquerorOfThreeWorldsRagnarakuAbility> INSTANCE = new AbilityCore.Builder("Conqueror of Three Worlds Ragnaraku", AbilityCategory.STYLE, ConquerorOfThreeWorldsRagnarakuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)70.0f, (float)80.0f), CooldownComponent.getTooltip((float)600.0f, (float)800.0f), RangeComponent.getTooltip((float)5.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(ConquerorOfThreeWorldsRagnarakuAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.INIT_JUMP, new AbilityPool2[0]);
    private static final int COOLDOWN = 600;
    private static final float RANGE = 5.0f;
    private static final int AWK_COOLDOWN = 800;
    private static final float AWK_DAMAGE = 80.0f;
    private static final float DMG = 70.0f;
    private boolean awakened = false;

    public ConquerorOfThreeWorldsRagnarakuAbility(AbilityCore<ConquerorOfThreeWorldsRagnarakuAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.animationComponent, this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityLimits::requiresBluntWeapon);
    }

    public void onLanding(LivingEntity entity) {
        this.animationComponent.stop(entity);
        List targets = this.rangeComponent.getTargetsInArea(entity, 4.0f);
        targets.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setFistDamage();
        for (LivingEntity target : targets) {
            float damage = 70.0f;
            int duration = 100;
            if (OniHelper.hasAwakeningActive(entity)) {
                damage = 80.0f;
                duration = 140;
            }
            if (this.continuousComponent.getContinueTime() < 30.0f) {
                damage = 20.0f;
            }
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, damage, (DamageSource)source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 20));
            if (OniHelper.hasAwakeningActive(entity) && damage > 20.0f) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 25));
            }
            AbilityHelper.disableAbilities((LivingEntity)target, (int)duration, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (targets.size() > 0) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10));
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 2.0f);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0));
        this.awakened = false;
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)4.0, (double)speed.field_72449_c);
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, CartAnimations.RAGNARAKU_RIGHT_ARM);
        } else {
            this.animationComponent.start(entity, CartAnimations.RAGNARAKU_LEFT_ARM);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() >= 30.0f) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(2.75, 1.0, 2.75);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)-7.0, (double)speed.field_72449_c);
            if (this.continuousComponent.getContinueTime() == 30.0f) {
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 50.0f, 0.9f);
            }
        }
        if (OniHelper.hasAwakeningActive(entity)) {
            this.awakened = true;
        }
        if (!AbilityLimits.canUseBlunt(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!this.awakened) {
            this.cooldownComponent.startCooldown(entity, 600.0f);
        } else {
            this.cooldownComponent.startCooldown(entity, 800.0f);
        }
        this.animationComponent.stop(entity);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.BLUDGEON) && questProps.hasFinishedQuest(CartQuests.BLUDGEON_TRIAL_06);
    }
}

