/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.blacklegextra;

import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.blacklegextra.IfritPoeleAFrireProjectile;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.blackleg.ExtraHachisProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.blackleg.PoeleAFrireProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class CartExtraHachisAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"extra_hachis", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches a rapid barrage of kicks.", null), ImmutablePair.of((Object)"Launches a stronger rapid barrage of kicks that light opponents on fire.", null), ImmutablePair.of((Object)"Launches an even stronger rapid barrage of kicks that light opponents on fire for longer.", null)});
    private static final TranslationTextComponent EXTRA_HACHIS = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.extra_hachis", (String)"Extra Hachis"));
    private static final TranslationTextComponent POELE_A_FRIRE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.poele_a_frire", (String)"Po\u00eale \u00e0 Frire"));
    private static final TranslationTextComponent IFRIT_POELE_A_FRIRE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.ifrit_poele_a_frire", "Ifrit: Po\u00eale \u00e0 Frire"));
    private static final ResourceLocation POELE_A_FRIRE_ICON = new ResourceLocation("mineminenomi", "textures/abilities/poele_a_frire.png");
    private static final ResourceLocation IFRIT_POELE_A_FRIRE_ICON = new ResourceLocation("cartaddon", "textures/abilities/ifrit_poele_a_frire.png");
    private static final float NORMAL_COOLDOWN = 240.0f;
    private static final float POELE_A_FRIRE_COOLDOWN = 300.0f;
    public static final AbilityCore<CartExtraHachisAbility> INSTANCE = new AbilityCore.Builder("Extra Hachis", AbilityCategory.STYLE, CartExtraHachisAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> EXTRA_HACHIS.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)8.0f), CooldownComponent.getTooltip((float)240.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> POELE_A_FRIRE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> IFRIT_POELE_A_FRIRE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[2], ChargeComponent.getTooltip((float)12.0f), CooldownComponent.getTooltip((float)340.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(CartExtraHachisAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);

    public CartExtraHachisAbility(AbilityCore<CartExtraHachisAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.repeaterComponent, this.altModeComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.repeaterComponent.start(entity, 20, 2);
        }
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        Object poeleAFrireProjectile;
        int projectileSpace = 2;
        float speed = 2.0f;
        Vector3d pos = new Vector3d(entity.func_226277_ct_() + WyHelper.randomWithRange((int)(-projectileSpace), (int)projectileSpace) + WyHelper.randomDouble(), entity.func_226278_cu_() + 1.5 + WyHelper.randomWithRange((int)0, (int)projectileSpace) + WyHelper.randomDouble(), entity.func_226281_cx_() + WyHelper.randomWithRange((int)(-projectileSpace), (int)projectileSpace) + WyHelper.randomDouble());
        ExtraHachisProjectile extraHachisProjectile = new ExtraHachisProjectile(entity.field_70170_p, entity, (Ability)this);
        if (this.altModeComponent.getCurrentMode() == Mode.POELE_A_FRIRE) {
            speed = 3.0f;
            poeleAFrireProjectile = new PoeleAFrireProjectile(entity.field_70170_p, entity, (Ability)this);
            poeleAFrireProjectile.setMaxLife(13);
            poeleAFrireProjectile.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)poeleAFrireProjectile);
            poeleAFrireProjectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 1.5f);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.IFRIT_POELE_A_FRIRE) {
            speed = 3.5f;
            poeleAFrireProjectile = new IfritPoeleAFrireProjectile(entity.field_70170_p, entity, this);
            poeleAFrireProjectile.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)poeleAFrireProjectile);
            poeleAFrireProjectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 1.5f);
        }
        extraHachisProjectile.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
        extraHachisProjectile.setMaxLife(3);
        entity.field_70170_p.func_217376_c((Entity)extraHachisProjectile);
        extraHachisProjectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 1.0f);
        ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
            this.cooldownComponent.startCooldown(entity, 240.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.POELE_A_FRIRE) {
            this.cooldownComponent.startCooldown(entity, 300.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.IFRIT_POELE_A_FRIRE) {
            this.cooldownComponent.startCooldown(entity, 340.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NORMAL) {
            this.setDisplayIcon(INSTANCE);
            this.setDisplayName((ITextComponent)INSTANCE.getLocalizedName());
        } else if (mode == Mode.POELE_A_FRIRE) {
            super.setDisplayName((ITextComponent)POELE_A_FRIRE_NAME);
            super.setDisplayIcon(POELE_A_FRIRE_ICON);
        } else if (mode == Mode.IFRIT_POELE_A_FRIRE) {
            super.setDisplayName((ITextComponent)IFRIT_POELE_A_FRIRE_NAME);
            super.setDisplayIcon(IFRIT_POELE_A_FRIRE_ICON);
        }
    }

    public void setNormal(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.NORMAL);
    }

    public void setDiable(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.POELE_A_FRIRE);
    }

    public void setIfrite(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.IFRIT_POELE_A_FRIRE);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(CartQuests.BLACKLEG_TRIAL_02);
    }

    public static enum Mode {
        NORMAL,
        POELE_A_FRIRE,
        IFRIT_POELE_A_FRIRE;

    }
}

