/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.blacklegextra;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.blacklegextra.CartBienCuitGrillShotAbility;
import net.MrMagicalCart.cartaddon.abilities.blacklegextra.CartExtraHachisAbility;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.AdvancedBlackLegTrainerEntity;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class CartDiableJambeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"diable_jambe", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user heats up their leg, dealing additional damage and shortly setting the target on fire.", null), ImmutablePair.of((Object)"The user heats up their leg even more, dealing additional damage and shortly setting the target on even hotter fire. (Fruitless)", null)});
    private static final TranslationTextComponent DIALBE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.diable_jambe", (String)"Diable Jambe"));
    private static final TranslationTextComponent IFRIT_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.ifrit_jambe", "Ifrit Jambe"));
    private static final ResourceLocation IFRIT_ICON = new ResourceLocation("cartaddon", "textures/abilities/ifrit_jambe.png");
    private static final float HOLD_TIME = 600.0f;
    private static final float MIN_COOLDOWN = 80.0f;
    private static final float MAX_COOLDOWN = 680.0f;
    public static final AbilityCore<CartDiableJambeAbility> INSTANCE = new AbilityCore.Builder("Diable Jambe", AbilityCategory.STYLE, CartDiableJambeAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> DIALBE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)80.0f, (float)380.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> IFRIT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip((float)80.0f, (float)680.0f)}).setSourceElement(SourceElement.FIRE).setUnlockCheck(CartDiableJambeAbility::canUnlock).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.HOT_BOILING_SPECIAL_ARM).setColor("#FFBB44AA").build();
    private static final AbilityAttributeModifier DIABLE_JAMBE_STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("9afcbbe3-4105-4390-90a9-8133e9c426fe"), INSTANCE, "Diable/Ifrite Jambe Attack Bonus", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier DIABLE_JAMBE_ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0c60d979-2c69-45e1-86d9-ad276db5b3f1"), INSTANCE, "Diable/Ifrite Jambe Attack Speed Bonus", (double)0.4f, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier DIABLE_JAMBE_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("ee13d935-0634-4a9a-9fea-7adf0f84109d"), INSTANCE, "Diable/Ifrite Jambe Speed Bonus", 0.03, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onContinuityStartEvent).addTickEvent(100, this::onContinuityTickEvent).addEndEvent(100, this::onContinuityEndEvent);
    private final SkinOverlayComponent skinOverlayComponent;
    private final ChangeStatsComponent statsComponent;
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.DIABLE).addChangeModeEvent(this::onAltModeChange);
    private boolean frozen = false;

    public CartDiableJambeAbility(AbilityCore<CartDiableJambeAbility> core) {
        super(core);
        this.skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
        this.statsComponent = new ChangeStatsComponent((IAbility)this);
        this.isNew = true;
        Predicate<LivingEntity> isActive = entity -> this.continuousComponent.isContinuous();
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)DIABLE_JAMBE_ATTACK_SPEED_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)DIABLE_JAMBE_STRENGTH_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)DIABLE_JAMBE_SPEED_MODIFIER, isActive);
        this.addComponents(new AbilityComponent[]{this.altModeComponent, this.continuousComponent, this.skinOverlayComponent, this.statsComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof AdvancedBlackLegTrainerEntity) {
            this.altModeComponent.setMode(entity, (Enum)Mode.IFRIT);
        }
        if (!this.continuousComponent.isContinuous()) {
            if (this.altModeComponent.getCurrentMode() == Mode.DIABLE) {
                this.continuousComponent.triggerContinuity(entity, 600.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.IFRIT) {
                if (!HakiHelper.hasAdvancedBusoActive((LivingEntity)entity) && entity instanceof PlayerEntity) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("You need to activate Internal Destruction to use this move!"), entity.func_110124_au());
                    return;
                }
                if (AbilityLimits.ateFruit(entity, (IAbility)this) && entity instanceof PlayerEntity) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("You cannot activate Ifrit Jambe with a fruit!"), entity.func_110124_au());
                    return;
                }
                this.continuousComponent.triggerContinuity(entity, 600.0f);
            }
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityStartEvent(LivingEntity entity, IAbility ability) {
        this.frozen = false;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        CartExtraHachisAbility extraHachis = (CartExtraHachisAbility)abilityProps.getEquippedAbility(CartExtraHachisAbility.INSTANCE);
        CartBienCuitGrillShotAbility grill = (CartBienCuitGrillShotAbility)abilityProps.getEquippedAbility(CartBienCuitGrillShotAbility.INSTANCE);
        if (this.altModeComponent.getCurrentMode() == Mode.DIABLE) {
            if (extraHachis != null) {
                extraHachis.setDiable(entity);
            }
            if (grill != null) {
                grill.setDiable(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.IFRIT) {
            if (extraHachis != null) {
                extraHachis.setIfrite(entity);
            }
            if (grill != null) {
                grill.setIfrite(entity);
            }
        }
    }

    private void onContinuityTickEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70644_a((Effect)ModEffects.FROZEN.get())) {
            this.frozen = true;
            AbilityHelper.reduceEffect((EffectInstance)entity.func_70660_b((Effect)ModEffects.FROZEN.get()), (double)1.1f);
            this.continuousComponent.stopContinuity(entity);
        } else if (entity.func_70644_a((Effect)ModEffects.FROSTBITE.get())) {
            this.frozen = true;
            AbilityHelper.reduceEffect((EffectInstance)entity.func_70660_b((Effect)ModEffects.FROSTBITE.get()), (double)1.5);
            this.continuousComponent.stopContinuity(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.DIABLE) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.DIABLE_JAMBE.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        } else if (this.altModeComponent.getCurrentMode() == Mode.IFRIT) {
            if (AbilityLimits.ateFruit(entity, ability)) {
                this.continuousComponent.stopContinuity(entity);
            }
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.IFRIT_JAMBE.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            if (!HakiHelper.hasAdvancedBusoActive((LivingEntity)entity) && entity instanceof PlayerEntity) {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void onContinuityEndEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.DIABLE) {
            this.cooldownComponent.startCooldown(entity, (this.frozen ? 160.0f : 80.0f) + this.continuousComponent.getContinueTime() / 2.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.IFRIT) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
            if (!props.getRace().equals((Object)CartValues.MODIFIED_HUMAN)) {
                this.cooldownComponent.startCooldown(entity, (this.frozen ? 160.0f : 80.0f) + this.continuousComponent.getContinueTime());
            } else {
                this.cooldownComponent.startCooldown(entity, (this.frozen ? 160.0f : 80.0f) + this.continuousComponent.getContinueTime() * 0.6f);
            }
        }
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        CartExtraHachisAbility extraHachis = (CartExtraHachisAbility)abilityProps.getEquippedAbility(CartExtraHachisAbility.INSTANCE);
        CartBienCuitGrillShotAbility grill = (CartBienCuitGrillShotAbility)abilityProps.getEquippedAbility(CartBienCuitGrillShotAbility.INSTANCE);
        if (extraHachis != null) {
            extraHachis.setNormal(entity);
        }
        if (grill != null) {
            grill.setDiable(entity);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.DIABLE) {
            this.setDisplayIcon(INSTANCE);
            this.setDisplayName((ITextComponent)INSTANCE.getLocalizedName());
        } else if (mode == Mode.IFRIT) {
            this.setDisplayIcon(IFRIT_ICON);
            this.setDisplayName((ITextComponent)IFRIT_NAME);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(CartQuests.BLACKLEG_TRIAL_05);
    }

    public boolean isIfrit() {
        return this.altModeComponent.getCurrentMode() == Mode.IFRIT;
    }

    public static enum Mode {
        DIABLE,
        IFRIT;

    }
}

