/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.blacklegextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.blacklegextra.CartDiableJambeAbility;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartBienCuitGrillShotAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bien_cuit_grill_shot", (Pair[])new Pair[]{ImmutablePair.of((Object)"A strong kick that launches the user forwards and creates a grill-patterned particle to appear, which sets anyone touching it on fire.", null), ImmutablePair.of((Object)"A stronger kick that launches the user forwards and creates a blue grill-patterned particle to appear, which sets anyone touching it on fire.", null)});
    private static final TranslationTextComponent DIABLE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.bien_cuit_grill_shot", "Bien Cuit: Grill Shot"));
    private static final TranslationTextComponent IFRIT_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.ifrit_bien_cuit_grill_shot", "Ifrit Bien Cuit: Grill Shot"));
    private static final ResourceLocation IFRIT_ICON = new ResourceLocation("cartaddon", "textures/abilities/ifrit_bien_cuit_grill_shot.png");
    private static final float COOLDOWN = 240.0f;
    private static final float RANGE = 1.8f;
    private static final float DAMAGE = 30.0f;
    public static final AbilityCore<CartBienCuitGrillShotAbility> INSTANCE = new AbilityCore.Builder("Bien Cuit Grill Shot", AbilityCategory.STYLE, CartBienCuitGrillShotAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> DIABLE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)45.0f), CooldownComponent.getTooltip((float)240.0f), RangeComponent.getTooltip((float)1.8f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> IFRIT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)65.0f), CooldownComponent.getTooltip((float)240.0f), RangeComponent.getTooltip((float)1.8f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(CartBienCuitGrillShotAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuityEvent).addTickEvent(this::continuousTickEvent).addEndEvent(this::continuousEndsEvent);
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.DIABLE, true).addChangeModeEvent(this::onAltModeChange);
    private boolean ifrite = false;

    public CartBienCuitGrillShotAbility(AbilityCore<CartBienCuitGrillShotAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.altModeComponent, this.dealDamageComponent, this.rangeComponent, this.hitTrackerComponent, this.continuousComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(this::hasDiableJambeActive);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        float horizontalPropulsion = 3.0f;
        CartDiableJambeAbility diableJambeAbility = (CartDiableJambeAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartDiableJambeAbility.INSTANCE);
        if (!diableJambeAbility.isIfrit()) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.BIEN_CUIT_GRILL_SHOT.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        } else if (diableJambeAbility.isIfrit()) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.IFRIT_BIEN_CUIT_GRILL_SHOT.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            horizontalPropulsion = 4.0f;
            this.ifrite = true;
        }
        Vector3d speed = entity.func_70040_Z().func_216372_d((double)horizontalPropulsion, 0.0, (double)horizontalPropulsion);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)0.3, (double)speed.field_72449_c);
    }

    private void continuousTickEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.8f);
            targets.remove(entity);
            Vector3d pushSpeed = entity.func_70040_Z().func_216372_d(2.0, 0.0, 2.0);
            for (LivingEntity target : targets) {
                float dmg = 45.0f;
                if (this.ifrite) {
                    dmg = 65.0f;
                }
                if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, dmg)) continue;
                AbilityHelper.setDeltaMovement((Entity)target, (double)pushSpeed.field_72450_a, (double)0.2, (double)pushSpeed.field_72449_c);
                AbilityHelper.setSecondsOnFireBy((Entity)target, (int)2, (LivingEntity)entity);
            }
        }
    }

    private void continuousEndsEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
        this.ifrite = false;
    }

    public AbilityUseResult hasDiableJambeActive(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        CartDiableJambeAbility diableJambeAbility = (CartDiableJambeAbility)props.getEquippedAbility(CartDiableJambeAbility.INSTANCE);
        return diableJambeAbility != null && diableJambeAbility.isContinuous() ? AbilityUseResult.success() : AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_DIABLE_JAMBE));
    }

    public void setDiable(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.DIABLE);
    }

    public void setIfrite(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.IFRIT);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.DIABLE) {
            this.setDisplayIcon(INSTANCE);
            this.setDisplayName((ITextComponent)INSTANCE.getLocalizedName());
        } else if (mode == Mode.IFRIT) {
            this.setDisplayIcon(IFRIT_ICON);
            this.setDisplayName((ITextComponent)IFRIT_NAME);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(CartQuests.BLACKLEG_TRIAL_05);
    }

    public static enum Mode {
        DIABLE,
        IFRIT;

    }
}

