/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.blacklegextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.blacklegextra.CartDiableJambeAbility;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BeoufBurstAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"beouf_burst", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges, and delivers a devastating kick into the opponent.", null)});
    private static final float COOLDOWN = 800.0f;
    private static final int CHARGE_TIME = 15;
    private static final float DAMAGE = 85.0f;
    private static final float RANGE = 3.0f;
    private static final float MAX_TELEPORT_DISTANCE = 30.0f;
    public static final AbilityCore<BeoufBurstAbility> INSTANCE = new AbilityCore.Builder("Beouf Burst", AbilityCategory.STYLE, BeoufBurstAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)40.0f, (float)95.0f), ChargeComponent.getTooltip((float)15.0f), CooldownComponent.getTooltip((float)800.0f), RangeComponent.getTooltip((float)30.0f, (float)33.5f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.FIRE).setUnlockCheck(BeoufBurstAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public BeoufBurstAbility(AbilityCore<BeoufBurstAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addCanUseCheck(AbilityLimits::fruitless);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        CartDiableJambeAbility diableJambeAbility = (CartDiableJambeAbility)props.getEquippedAbility(CartDiableJambeAbility.INSTANCE);
        if (diableJambeAbility == null || !diableJambeAbility.isIfrit() || !diableJambeAbility.isContinuous()) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("B\u0153uf Burst requires Ifrit Jambe active!"), entity.func_110124_au());
            return;
        }
        this.chargeComponent.startCharging(entity, 15.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)0.0, (double)0.0, (double)0.0);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BEOUF_BURST.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        BlockPos blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)30.0f);
        AbilityDamageSource source = (AbilityDamageSource)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setPhysical();
        Vector3d startPos = entity.func_213303_ch();
        float actualTeleportDistance = 30.0f;
        for (double f = 0.0; f < 1.0; f += 0.13) {
            double z;
            double y;
            double x = MathHelper.func_219803_d((double)f, (double)startPos.func_82615_a(), (double)blockpos.func_177958_n());
            Vector3d pos = new Vector3d(x, y = MathHelper.func_219803_d((double)f, (double)startPos.func_82617_b(), (double)blockpos.func_177956_o()), z = MathHelper.func_219803_d((double)f, (double)startPos.func_82616_c(), (double)blockpos.func_177952_p()));
            List projectiles = WyHelper.getNearbyEntities((Vector3d)pos, (IWorld)entity.field_70170_p, (double)entity.func_213311_cf(), (double)entity.func_213302_cg(), (double)entity.func_213311_cf(), (Predicate)null, (Class[])new Class[]{ProjectileEntity.class});
            if (projectiles.isEmpty()) continue;
            projectiles.sort(TargetHelper.closestComparator((Vector3d)startPos));
            actualTeleportDistance = MathHelper.func_76133_a((double)((ProjectileEntity)projectiles.get(0)).func_195048_a(startPos));
            break;
        }
        blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)actualTeleportDistance);
        List targets = this.rangeComponent.getTargetsInLine(entity, actualTeleportDistance, 3.5f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            boolean flag = this.dealDamageComponent.hurtTarget(entity, target, 95.0f, (DamageSource)source);
            Vector3d speed = entity.func_70040_Z().func_72432_b().func_216372_d(4.0, 1.0, 4.0).func_72441_c(0.0, 0.15, 0.0);
            target.func_70015_d(5);
            target.func_213317_d(speed);
            if (flag && entity.field_70170_p.field_72995_K) continue;
        }
        this.hitTrackerComponent.clearHits();
        targets = this.rangeComponent.getTargetsInLine(entity, 3.5f, 3.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            boolean flag = this.dealDamageComponent.hurtTarget(entity, target, 40.0f, (DamageSource)source);
            Vector3d speed = entity.func_70040_Z().func_72432_b().func_216372_d(8.0, 1.0, 8.0).func_72441_c(0.0, 0.9, 0.0);
            target.func_70015_d(5);
            target.func_213317_d(speed);
            if (flag && entity.field_70170_p.field_72995_K) continue;
        }
        entity.func_184210_p();
        entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.25f);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 800.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(CartQuests.BLACKLEG_TRIAL_06);
    }
}

