/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bisu;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.bisu.BisuArmorAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class PretzelRollAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"pretzel_roll", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user thrusts their sword into an opponent, stunning them, applying dizziness and bleeding. (Increases damage and applies longer dizzy with \u00a7aBisu Armor\u00a7r)", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int HOLD_TIME = 6;
    private static final int COOLDOWN = 200;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 40.0f;
    public static final AbilityCore<PretzelRollAbility> INSTANCE = new AbilityCore.Builder("Pretzel Roll", AbilityCategory.DEVIL_FRUITS, PretzelRollAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)35.0f, (float)45.0f), CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)1.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.SLASH}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public PretzelRollAbility(AbilityCore<PretzelRollAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 6.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.POINT_WEAPON);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
            BisuArmorAbility bisuArmorAbility = (BisuArmorAbility)abilityProps.getEquippedAbility(BisuArmorAbility.INSTANCE);
            boolean bisuActive = bisuArmorAbility != null && bisuArmorAbility.isContinuous();
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(1.6, 0.0, 1.6);
            entity.func_213315_a(MoverType.SELF, speed);
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.0f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                float damage = 35.0f;
                if (bisuActive) {
                    damage = 45.0f;
                }
                this.dealDamageComponent.hurtTarget(entity, target, damage);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 20, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 100, 0, false, false));
                if (!bisuActive) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
                    continue;
                }
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 120, 0, false, false));
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                target.func_70634_a(entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_(), entity.func_226281_cx_() + look.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

