/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bisu;

import net.MrMagicalCart.cartaddon.abilities.bisu.AdvancedBisuHeiAbility;
import net.MrMagicalCart.cartaddon.abilities.bisu.BisuArmorAbility;
import net.MrMagicalCart.cartaddon.abilities.bisu.BisuHelper;
import net.MrMagicalCart.cartaddon.entities.mobs.ability.BisuHeiEntity;
import net.MrMagicalCart.cartaddon.init.CartItems;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BisuHeiAbility
extends Ability {
    private static final int CHARGE_TIME = 240;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 1540;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bisu_hei", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates Bisu Soldiers using Large Biscuits from the user's inventory, the longer the ability charges the more soldiers it'll create. (Create large biscuits with normal biscuits shaped like the crafting table recipe)", null)});
    public static final AbilityCore<BisuHeiAbility> INSTANCE = new AbilityCore.Builder("Bisu Hei", AbilityCategory.DEVIL_FRUITS, BisuHeiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)240.0f), CooldownComponent.getTooltip((float)100.0f, (float)1540.0f)}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> this.getSpawnAmount() > 0).addTickEvent(100, this::duringChargingEvent).addEndEvent(100, this::stopChargingEvent);
    private final StackComponent stackComponent = new StackComponent((IAbility)this);
    private int prevSpawnAmount;

    public BisuHeiAbility(AbilityCore<BisuHeiAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), BisuArmorAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.ADVANCED_BISU_HEI.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)text) : AbilityUseResult.success();
        });
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.stackComponent});
        this.addCanUseCheck(this::canUseCheck);
        this.addCanUseCheck(this::usingBisuHei);
        this.addUseEvent(this::onUseEvent);
    }

    private AbilityUseResult usingBisuHei(LivingEntity entity, IAbility ability) {
        boolean advBisuActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        AdvancedBisuHeiAbility advancedBisuHeiAbility = (AdvancedBisuHeiAbility)abilityProps.getEquippedAbility(AdvancedBisuHeiAbility.INSTANCE);
        boolean bl = advBisuActive = advancedBisuHeiAbility != null && advancedBisuHeiAbility.isCharging();
        if (advBisuActive) {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), AdvancedBisuHeiAbility.INSTANCE.getUnlocalizedName()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }

    private AbilityUseResult canUseCheck(LivingEntity entity, IAbility ability) {
        return ItemsHelper.countItemInInventory((LivingEntity)entity, (Item)((Item)CartItems.LARGE_BISU.get())) <= 0 ? AbilityUseResult.fail((ITextComponent)BisuHelper.NOT_ENOUGH_BISU_WARN) : AbilityUseResult.success();
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 240.0f);
    }

    private void duringChargingEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BISU_HEI.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 2, false, false));
        int spawnAmount = this.getSpawnAmount();
        if (ItemsHelper.countItemInInventory((LivingEntity)entity, (Item)((Item)CartItems.LARGE_BISU.get())) < spawnAmount) {
            entity.func_145747_a(BisuHelper.NOT_ENOUGH_BISU_WARN, Util.field_240973_b_);
            this.chargeComponent.stopCharging(entity);
        } else if (spawnAmount != this.prevSpawnAmount) {
            this.stackComponent.setStacks(entity, (IAbility)this, spawnAmount);
            this.prevSpawnAmount = spawnAmount;
        }
    }

    private boolean stopChargingEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f + this.chargeComponent.getChargeTime() * 6.0f);
        int spawned = this.getSpawnAmount();
        BisuHelper.removeBisu(entity, spawned);
        for (int i = 0; i < spawned; ++i) {
            BisuHeiEntity hei = new BisuHeiEntity(entity.field_70170_p, entity);
            hei.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
            hei.setOwner(entity);
            entity.field_70170_p.func_217376_c((Entity)hei);
        }
        this.prevSpawnAmount = 0;
        this.stackComponent.setStacks(entity, (IAbility)this, 0);
        return true;
    }

    private int getSpawnAmount() {
        return (int)(this.chargeComponent.getChargeTime() / 40.0f);
    }
}

