/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bisu;

import net.MrMagicalCart.cartaddon.abilities.bisu.BisuArmorAbility;
import net.MrMagicalCart.cartaddon.abilities.bisu.BisuHelper;
import net.MrMagicalCart.cartaddon.init.CartItems;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BisuGuardAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bisu_guard", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates a shield of biscuits that protects the user from any attack. (consumes a max of 2 biscuits for the full length time)", null)});
    private static final int HOLD_TIME = 60;
    private static final int COOLDOWN = 400;
    public static final AbilityCore<BisuGuardAbility> INSTANCE = new AbilityCore.Builder("Bisu Guard", AbilityCategory.DEVIL_FRUITS, BisuGuardAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::startContinuousEvent).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);

    public BisuGuardAbility(AbilityCore<BisuGuardAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.animationComponent, this.poolComponent});
        this.addCanUseCheck(this::canUseCheck);
        this.addUseEvent(this::useEvent);
    }

    private AbilityUseResult canUseCheck(LivingEntity entity, IAbility ability) {
        return ItemsHelper.countItemInInventory((LivingEntity)entity, (Item)((Item)CartItems.BISU.get())) <= 0 ? AbilityUseResult.fail((ITextComponent)BisuHelper.NOT_ENOUGH_NORMAL_BISU_WARN) : AbilityUseResult.success();
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        boolean bisuActive;
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.5);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 5, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        BisuArmorAbility bisuArmorAbility = (BisuArmorAbility)abilityProps.getEquippedAbility(BisuArmorAbility.INSTANCE);
        boolean bl = bisuActive = bisuArmorAbility != null && bisuArmorAbility.isContinuous();
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            if (!bisuActive) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BISU_GUARD.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 0.25 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
            } else {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BISU_GUARD.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 2.25 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
            }
        }
        if (ItemsHelper.countItemInInventory((LivingEntity)entity, (Item)((Item)CartItems.BISU.get())) > 0) {
            if (this.continuousComponent.getContinueTime() % 30.0f == 0.0f) {
                BisuHelper.removeNormalBisu(entity, 1);
            }
        } else {
            entity.func_145747_a(BisuHelper.NOT_ENOUGH_NORMAL_BISU_WARN, Util.field_240973_b_);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

