/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bisu;

import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BisuEntityGuardAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bisu__entity_guard", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates a shield of biscuits that protects the user from any attack.", null)});
    private static final int HOLD_TIME = 100;
    private static final int COOLDOWN = 400;
    public static final AbilityCore<BisuEntityGuardAbility> INSTANCE = new AbilityCore.Builder("Bisu Entity Guard", AbilityCategory.DEVIL_FRUITS, BisuEntityGuardAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)400.0f)}).setHidden().build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);

    public BisuEntityGuardAbility(AbilityCore<BisuEntityGuardAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.poolComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.5);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 5, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BISU_GUARD.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 2.25 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

