/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.bisu;

import net.MrMagicalCart.cartaddon.abilities.bisu.BisuArmorAbility;
import net.MrMagicalCart.cartaddon.init.CartItems;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BisuCreationAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bisu_creation", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user claps their hand, creating a biscuit.", null)});
    protected final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private static final float COOLDOWN = 30.0f;
    public static final AbilityCore<BisuCreationAbility> INSTANCE = new AbilityCore.Builder("Bisu Creation", AbilityCategory.DEVIL_FRUITS, BisuCreationAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)30.0f)}).build();

    public BisuCreationAbility(AbilityCore<BisuCreationAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.itemSpawnComponent, this.animationComponent});
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        boolean bisuActive;
        this.itemSpawnComponent.spawnItem(entity, this.createItemStack(entity));
        this.animationComponent.start(entity, ModAnimations.BON, 7);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        BisuArmorAbility bisuArmorAbility = (BisuArmorAbility)abilityProps.getEquippedAbility(BisuArmorAbility.INSTANCE);
        boolean bl = bisuActive = bisuArmorAbility != null && bisuArmorAbility.isContinuous();
        if (!bisuActive) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BISU_CREATION.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        } else {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BISU_CREATION.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 5.0), (double)entity.func_226281_cx_());
        }
        this.cooldownComponent.startCooldown(entity, 30.0f);
    }

    public ItemStack createItemStack(LivingEntity entity) {
        ItemStack itemStack = new ItemStack((IItemProvider)CartItems.BISU.get());
        return itemStack;
    }
}

