/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.batto;

import net.MrMagicalCart.cartaddon.entities.projectiles.batto.SonicBoomProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;

public class SonicBoomAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"sonic_boom", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a blast of air at their opponent, applying nausea, dizziness, slowness, mining fatigue, and stun.", null)});
    private static final float CHARGE_TIME = 60.0f;
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<SonicBoomAbility> INSTANCE = new AbilityCore.Builder("Sonic Boom", AbilityCategory.DEVIL_FRUITS, SonicBoomAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent;

    public SonicBoomAbility(AbilityCore<SonicBoomAbility> core) {
        super(core);
        this.isNew = true;
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.BATTO_FLY.get(), new MorphInfo[]{(MorphInfo)CartMorphs.BATTO_HEAVY_POINT.get()});
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent, this.requireMorphComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187740_w, SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 1.1f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private SonicBoomProjectile createProjectile(LivingEntity entity) {
        SonicBoomProjectile proj = new SonicBoomProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

