/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.batto;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.batto.BattoFlightAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class BattoFlyPointAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"batto_fly_point", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user into a nimble bat.", null)});
    public static final AbilityCore<BattoFlyPointAbility> INSTANCE = new AbilityCore.Builder("Batto Fly Point", AbilityCategory.DEVIL_FRUITS, BattoFlyPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Batto Fly Point Speed Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Batto Fly Point Armor Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Batto Fly Point Strength Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private final float COOLDOWN = 200.0f;
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);

    public BattoFlyPointAbility(AbilityCore<BattoFlyPointAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)SPEED_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isMorphed);
        this.continuousComponent.addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility battoFlightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (battoFlightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(BattoFlightAbility.INSTANCE)) != null && !battoFlightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility battoFlightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (battoFlightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(BattoFlightAbility.INSTANCE)) != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous()) {
            return damage * 1.25f;
        }
        return damage;
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.BATTO_FLY.get();
    }
}

