/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.init.CartWeapons;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BazookaBurnBlastAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bazooka_burn_blast", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges their Burn Bazooka, unleashing a devastating blast that deals damage and lights opponents on fire.", null)});
    private static final int CHARGE_TIME = 60;
    private static final int COOLDOWN = 240;
    public static final AbilityCore<BazookaBurnBlastAbility> INSTANCE = new AbilityCore.Builder("Bazooka Burn Blast", AbilityCategory.EQUIPMENT, BazookaBurnBlastAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)20.0f, (float)55.0f), ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)200.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setUnlockCheck(BazookaBurnBlastAbility::canUnlock).setSourceElement(SourceElement.FIRE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private boolean stopped = false;

    public BazookaBurnBlastAbility(AbilityCore<BazookaBurnBlastAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.chargeComponent, this.dealDamageComponent, this.rangeComponent});
        super.addUseEvent(this::useEvent);
        super.addEquipEvent(this::equipEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_77973_b().equals(CartWeapons.BURN_BAZOOKA.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a Burn Bazooka to use this move!"), entity.func_110124_au());
            return;
        }
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        }
        if (entity.func_184591_cq() == HandSide.LEFT) {
            this.animationComponent.start(entity, ModAnimations.POINT_LEFT_ARM);
        }
        this.stopped = false;
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CHARGE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() == 39.0f) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PRE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BURN_BAZOOKA.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        if (!entity.func_184614_ca().func_77973_b().equals(CartWeapons.BURN_BAZOOKA.get()) && !this.stopped) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a Burn Bazooka to use this move!"), entity.func_110124_au());
            this.stopped = true;
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        if (!this.stopped) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)64.0);
            double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
            float size = 0.25f;
            float length = 50.0f;
            Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)1.15, (double)0.8);
            LightningEntity bolt = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, 10.0f, this.getCore());
            bolt.setBlocksAffectedLimit(4000);
            bolt.setMaxLife(40);
            bolt.setDamage(0.0f);
            bolt.setExplosion(4, true);
            bolt.setSize(size);
            bolt.setBoxSizeDivision(1.0);
            bolt.setColor(WyHelper.hexToRGB((String)"#2dcbc8"));
            bolt.setAngle(100);
            bolt.setTargetTimeToReset(60);
            bolt.disableExplosionKnockback();
            bolt.setBranches(1);
            bolt.setSegments(1);
            entity.field_70170_p.func_217376_c((Entity)bolt);
            float dmg = 20.0f;
            IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
            if (props.isSniper()) {
                dmg += 25.0f;
            }
            if (props.equals(CartValues.SKY_FOLK)) {
                dmg += 10.0f;
            }
            List list = this.rangeComponent.getTargetsInLine(entity, 64.0f, 2.5f);
            for (LivingEntity target : list) {
                target.func_70015_d(3);
                this.dealDamageComponent.hurtTarget(entity, target, dmg);
            }
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        return BazookaBurnBlastAbility.hasItem(entity);
    }

    private static boolean hasItem(LivingEntity entity) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(CartWeapons.BURN_BAZOOKA.get())) continue;
            return true;
        }
        return false;
    }
}

