/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.math.OpenAxisAlignedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.math.OpenOrientedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransformedBoundingBox;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShapeTesselator {
    private static final byte[][][] FACE_MARK_TEXTURES = new byte[][][]{new byte[][]{{1, 3}, {1, 0}, {0, 0}, {0, 3}}, new byte[][]{{1, 3}, {1, 0}, {0, 0}, {0, 3}}, new byte[][]{{1, 2}, {1, 0}, {0, 0}, {0, 2}}, new byte[][]{{1, 2}, {1, 0}, {0, 0}, {0, 2}}, new byte[][]{{3, 2}, {3, 0}, {0, 0}, {0, 2}}, new byte[][]{{3, 2}, {3, 0}, {0, 0}, {0, 2}}};
    private static final byte[][][] FACE_MARK_VERTEXES = new byte[][][]{new byte[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}, {0, -1, 0}}, new byte[][]{{1, 1, 1}, {1, 1, 0}, {0, 1, 0}, {0, 1, 1}, {0, 1, 0}}, new byte[][]{{0, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, 0, -1}}, new byte[][]{{1, 0, 1}, {1, 1, 1}, {0, 1, 1}, {0, 0, 1}, {0, 0, 1}}, new byte[][]{{0, 0, 1}, {0, 1, 1}, {0, 1, 0}, {0, 0, 0}, {-1, 0, 0}}, new byte[][]{{1, 0, 0}, {1, 1, 0}, {1, 1, 1}, {1, 0, 1}, {1, 0, 0}}};

    public static void point(IVector3f origin, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.point(origin.x(), origin.y(), origin.z(), 1.0f, poseStack, bufferSource);
    }

    public static void point(IVector3f origin, float length, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.point(origin.x(), origin.y(), origin.z(), length, poseStack, bufferSource);
    }

    public static void point(float x, float y, float z, float length, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.point(x, y, z, length, length, length, poseStack, bufferSource);
    }

    public static void point(float x, float y, float z, float width, float height, float depth, IPoseStack poseStack, IBufferSource bufferSource) {
        IPoseStack.Pose entry = poseStack.last();
        float minX = x - width * 0.5f;
        float minY = y - height * 0.5f;
        float minZ = z - depth * 0.5f;
        float midX = x + 0.0f;
        float midY = y + 0.0f;
        float midZ = z + 0.0f;
        float maxX = x + width * 0.5f;
        float maxY = y + height * 0.5f;
        float maxZ = z + depth * 0.5f;
        IVertexConsumer lineBuilder = bufferSource.getBuffer(SkinRenderType.lines());
        lineBuilder.vertex(entry, minX, midY, midZ).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, maxX, midY, midZ).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, minY, midZ).color(0, 255, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, maxY, midZ).color(0, 255, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, midY, minZ).color(0, 0, 255, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, midY, maxZ).color(0, 0, 255, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
    }

    public static void vector(IVector3f origin, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.vector(origin.x(), origin.y(), origin.z(), 1.0f, poseStack, bufferSource);
    }

    public static void vector(IVector3f origin, float length, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.vector(origin.x(), origin.y(), origin.z(), length, poseStack, bufferSource);
    }

    public static void vector(float x, float y, float z, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.vector(x, y, z, 1.0f, 1.0f, 1.0f, poseStack, bufferSource);
    }

    public static void vector(float x, float y, float z, float length, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.vector(x, y, z, length, length, length, poseStack, bufferSource);
    }

    public static void vector(float x, float y, float z, float width, float height, float depth, IPoseStack poseStack, IBufferSource bufferSource) {
        IPoseStack.Pose entry = poseStack.last();
        float minX = x - width * 0.5f;
        float minY = y - height * 0.5f;
        float minZ = z - depth * 0.5f;
        float midX = x + 0.0f;
        float midY = y + 0.0f;
        float midZ = z + 0.0f;
        float maxX = x + width * 0.5f;
        float maxY = y + height * 0.5f;
        float maxZ = z + depth * 0.5f;
        float n = width * 0.03f;
        float m = height * 0.1f;
        IVertexConsumer lineBuilder = bufferSource.getBuffer(SkinRenderType.lines());
        lineBuilder.vertex(entry, minX, midY, midZ).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, maxX, midY, midZ).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, minY, midZ).color(0, 255, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, maxY, midZ).color(0, 255, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, midY, minZ).color(0, 0, 255, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        lineBuilder.vertex(entry, midX, midY, maxZ).color(0, 0, 255, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        IVertexConsumer arrowBuilder = bufferSource.getBuffer(SkinRenderType.BLIT_COLOR);
        arrowBuilder.vertex(entry, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY + n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ + n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, maxX - m, midY - n, midZ - n).color(255, 0, 0, 255).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ + n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, maxY - m, midZ - n).color(0, 255, 0, 255).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY + n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX + n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        arrowBuilder.vertex(entry, midX - n, midY - n, maxZ - m).color(0, 0, 255, 255).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
    }

    public static void stroke(AxisAlignedBB rect, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke((float)rect.field_72340_a, (float)rect.field_72338_b, (float)rect.field_72339_c, (float)rect.field_72336_d, (float)rect.field_72337_e, (float)rect.field_72334_f, color, poseStack, bufferSource);
    }

    public static void stroke(IRectangle3f rect, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(rect.minX(), rect.minY(), rect.minZ(), rect.maxX(), rect.maxY(), rect.maxZ(), color, poseStack, bufferSource);
    }

    public static void stroke(IRectangle3i rect, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke((float)rect.minX(), (float)rect.minY(), (float)rect.minZ(), (float)rect.maxX(), (float)rect.maxY(), (float)rect.maxZ(), color, poseStack, bufferSource);
    }

    public static void stroke(OpenAxisAlignedBoundingBox aabb, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(aabb.minX(), aabb.minY(), aabb.minZ(), aabb.maxX(), aabb.maxY(), aabb.maxZ(), color, poseStack, bufferSource);
    }

    public static void stroke(OpenOrientedBoundingBox obb, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        poseStack.pushPose();
        poseStack.rotate(obb.orientation());
        ShapeTesselator.stroke(obb.boundingBox(), color, poseStack, bufferSource);
        poseStack.popPose();
    }

    public static void stroke(OpenTransformedBoundingBox tbb, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        poseStack.pushPose();
        poseStack.multiply(tbb.transform());
        poseStack.multiply(new OpenMatrix3f(tbb.transform()));
        ShapeTesselator.stroke(tbb.boundingBox(), color, poseStack, bufferSource);
        poseStack.popPose();
    }

    public static void stroke(JointShape shape, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        poseStack.pushPose();
        OpenRectangle3f rect = shape.bounds();
        shape.transform().apply(poseStack);
        ShapeTesselator.stroke((IRectangle3f)rect, color, poseStack, bufferSource);
        poseStack.translate(rect.x(), rect.y(), rect.z());
        for (JointShape shape1 : shape.children()) {
            ShapeTesselator.stroke(shape1, color, poseStack, bufferSource);
        }
        poseStack.popPose();
    }

    public static void stroke(float x0, float y0, float z0, float x1, float y1, float z1, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, color, poseStack, bufferSource.getBuffer(SkinRenderType.lines()));
    }

    public static void stroke(AxisAlignedBB rect, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(rect, color.value(), poseStack, bufferSource);
    }

    public static void stroke(IRectangle3f rect, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(rect, color.value(), poseStack, bufferSource);
    }

    public static void stroke(IRectangle3i rect, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(rect, color.value(), poseStack, bufferSource);
    }

    public static void stroke(OpenAxisAlignedBoundingBox aabb, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(aabb, color.value(), poseStack, bufferSource);
    }

    public static void stroke(OpenOrientedBoundingBox obb, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(obb, color.value(), poseStack, bufferSource);
    }

    public static void stroke(OpenTransformedBoundingBox tbb, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(tbb, color.value(), poseStack, bufferSource);
    }

    public static void stroke(JointShape shape, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(shape, color.value(), poseStack, bufferSource);
    }

    public static void stroke(float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke(x0, y0, z0, x1, y1, z1, color.value(), poseStack, bufferSource);
    }

    public static void fill(float x0, float y0, float z0, float x1, float y1, float z1, int color, IPoseStack poseStack, IVertexConsumer builder) {
        IPoseStack.Pose entry = poseStack.last();
        int r = ColorUtils.getRed(color);
        int g = ColorUtils.getGreen(color);
        int b = ColorUtils.getBlue(color);
        int a = ColorUtils.getAlpha(color);
        builder.vertex(entry, x0, y0, z0).color(r, g, b, a).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y0, z0).color(r, g, b, a).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y0, z0).color(r, g, b, a).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y1, z0).color(r, g, b, a).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y0, z0).color(r, g, b, a).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(entry, x0, y0, z1).color(r, g, b, a).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(entry, x1, y0, z0).color(r, g, b, a).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y1, z0).color(r, g, b, a).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y1, z0).color(r, g, b, a).normal(entry, -1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y1, z0).color(r, g, b, a).normal(entry, -1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y1, z0).color(r, g, b, a).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(entry, x0, y1, z1).color(r, g, b, a).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(entry, x0, y1, z1).color(r, g, b, a).normal(entry, 0.0f, -1.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y0, z1).color(r, g, b, a).normal(entry, 0.0f, -1.0f, 0.0f).endVertex();
        builder.vertex(entry, x0, y0, z1).color(r, g, b, a).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y0, z1).color(r, g, b, a).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y0, z1).color(r, g, b, a).normal(entry, 0.0f, 0.0f, -1.0f).endVertex();
        builder.vertex(entry, x1, y0, z0).color(r, g, b, a).normal(entry, 0.0f, 0.0f, -1.0f).endVertex();
        builder.vertex(entry, x0, y1, z1).color(r, g, b, a).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y1, z1).color(r, g, b, a).normal(entry, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y0, z1).color(r, g, b, a).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y1, z1).color(r, g, b, a).normal(entry, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(entry, x1, y1, z0).color(r, g, b, a).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(entry, x1, y1, z1).color(r, g, b, a).normal(entry, 0.0f, 0.0f, 1.0f).endVertex();
    }

    public static void fill(float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, IPoseStack poseStack, IVertexConsumer builder) {
        ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, color.value(), poseStack, builder);
    }

    public static void cube(IRectangle3i rect, float r, float g, float b, float a, IPoseStack poseStack, IBufferSource bufferSource) {
        float x = rect.minX();
        float y = rect.minY();
        float z = rect.minZ();
        float w = rect.width();
        float h = rect.height();
        float d = rect.depth();
        ShapeTesselator.cube(x, y, z, w, h, d, r, g, b, a, poseStack, bufferSource);
    }

    public static void cube(IRectangle3f rect, float r, float g, float b, float a, IPoseStack poseStack, IBufferSource bufferSource) {
        float x = rect.minX();
        float y = rect.minY();
        float z = rect.minZ();
        float w = rect.width();
        float h = rect.height();
        float d = rect.depth();
        ShapeTesselator.cube(x, y, z, w, h, d, r, g, b, a, poseStack, bufferSource);
    }

    public static void cube(IRectangle3f rect, float r, float g, float b, float a, IPoseStack poseStack, IVertexConsumer consumer) {
        float x = rect.minX();
        float y = rect.minY();
        float z = rect.minZ();
        float w = rect.width();
        float h = rect.height();
        float d = rect.depth();
        ShapeTesselator.cube(x, y, z, w, h, d, r, g, b, a, poseStack, consumer);
    }

    public static void cube(float x, float y, float z, float w, float h, float d, float r, float g, float b, float a, IPoseStack poseStack, IBufferSource bufferSource) {
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.IMAGE_GUIDE);
        ShapeTesselator.cube(x, y, z, w, h, d, r, g, b, a, poseStack, builder);
    }

    public static void cube(float x, float y, float z, float w, float h, float d, float r, float g, float b, float a, IPoseStack poseStack, IVertexConsumer consumer) {
        if (w == 0.0f || h == 0.0f || d == 0.0f) {
            return;
        }
        IPoseStack.Pose pose = poseStack.last();
        for (Direction dir : Direction.values()) {
            byte[][] vertexes = FACE_MARK_VERTEXES[dir.func_176745_a()];
            byte[][] textures = FACE_MARK_TEXTURES[dir.func_176745_a()];
            float u = 0.0f;
            float v = 0.0f;
            float[] values = new float[]{0.0f, w, h, d};
            for (int i = 0; i < 4; ++i) {
                consumer.vertex(pose, x + (float)vertexes[i][0] * w, y + (float)vertexes[i][1] * h, z + (float)vertexes[i][2] * d).color(r, g, b, a).uv(u + values[textures[i][0]], v + values[textures[i][1]]).overlayCoords(OverlayTexture.field_229196_a_).uv2(0xF000F0).endVertex();
            }
        }
    }
}

