/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.network.ExecuteCommandPacket;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.apache.commons.lang3.tuple.Pair;

public class ReflectArgumentBuilder<S>
extends LiteralArgumentBuilder<S> {
    private static final Map<Class<?>, Function<Pair<Object, Field>, ArgumentBuilder<CommandSource, ?>>> FIELD_BUILDERS = Collections.immutableMap(it -> {
        it.put(Boolean.TYPE, pair -> ReflectArgumentBuilder.field((Pair<Object, Field>)pair, BoolArgumentType.bool(), BoolArgumentType::getBool));
        it.put(Integer.TYPE, pair -> ReflectArgumentBuilder.field((Pair<Object, Field>)pair, IntegerArgumentType.integer(), IntegerArgumentType::getInteger));
        it.put(Double.TYPE, pair -> ReflectArgumentBuilder.field((Pair<Object, Field>)pair, DoubleArgumentType.doubleArg(), DoubleArgumentType::getDouble));
        it.put(Float.TYPE, pair -> ReflectArgumentBuilder.field((Pair<Object, Field>)pair, FloatArgumentType.floatArg(), FloatArgumentType::getFloat));
        it.put(String.class, pair -> ReflectArgumentBuilder.field((Pair<Object, Field>)pair, StringArgumentType.string(), StringArgumentType::getString));
    });
    private final Class<?> object;

    protected ReflectArgumentBuilder(String literal, Class<?> object) {
        super(literal);
        this.object = object;
    }

    public static ReflectArgumentBuilder<CommandSource> literal(String name, Class<?> object) {
        return new ReflectArgumentBuilder<CommandSource>(name, object);
    }

    private static <R> ArgumentBuilder<CommandSource, ?> field(Pair<Object, Field> pair, ArgumentType<R> argumentType, BiFunction<CommandContext<?>, String, R> argumentParser) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)((Field)pair.getValue()).getName()).then(Commands.func_197056_a((String)"value", argumentType).executes(context -> {
            Object value = argumentParser.apply(context, "value");
            String name = ((Field)pair.getValue()).getName();
            Class object = (Class)pair.getKey();
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            NetworkManager.sendTo(ExecuteCommandPacket.set(object, name, value), player);
            return 0;
        }))).executes(context -> {
            String name = ((Field)pair.getValue()).getName();
            Class object = (Class)pair.getKey();
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            NetworkManager.sendTo(ExecuteCommandPacket.get(object, name), player);
            return 0;
        });
    }

    public Collection<CommandNode<S>> getArguments() {
        ArrayList<CommandNode<S>> nodes = new ArrayList<CommandNode<S>>(super.getArguments());
        for (Field field : this.object.getDeclaredFields()) {
            Function<Pair<Object, Field>, ArgumentBuilder<CommandSource, ?>> function = FIELD_BUILDERS.get(field.getType());
            if (function == null) continue;
            nodes.add((CommandNode)Objects.unsafeCast(function.apply((Pair<Object, Field>)Pair.of(this.object, (Object)field)).build()));
        }
        return nodes;
    }
}

