/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.LazyValue;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.command.EntitySelectorPredicate;
import moe.plushie.armourers_workshop.init.command.ListArgumentType;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class HasSkinArgumentType
implements ArgumentType<EntitySelectorPredicate> {
    private static final DynamicCommandExceptionType ERROR_MISSING_KEY = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.unknownHasSkinKey", ob));
    private static final Map<String, LazyValue<ArgumentType<?>>> PROPERTIES = Collections.immutableMap(it -> {
        it.put((Object)"id", LazyValue.of(() -> StringArgumentType.string()));
        it.put((Object)"slot", LazyValue.of(() -> IntegerArgumentType.integer((int)1)));
        it.put((Object)"type", LazyValue.of(() -> new ListArgumentType(Collections.compactMap(SkinSlotType.values(), SkinSlotType::serializedName))));
    });

    public EntitySelectorPredicate parse(StringReader reader) throws CommandSyntaxException {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        reader.expect('{');
        reader.skipWhitespace();
        while (reader.canRead() && reader.peek() != '}') {
            reader.skipWhitespace();
            String key = reader.readUnquotedString();
            reader.skipWhitespace();
            reader.expect('=');
            reader.skipWhitespace();
            LazyValue<ArgumentType<?>> valueProvider = PROPERTIES.get(key);
            if (valueProvider == null) {
                throw ERROR_MISSING_KEY.create((Object)key);
            }
            Object value = valueProvider.get().parse(reader);
            conditions.put(key, value);
            reader.skipWhitespace();
            if (!reader.canRead() || reader.peek() != ',') continue;
            reader.skip();
        }
        reader.expect('}');
        return new PredicateImpl(conditions);
    }

    private static class PredicateImpl
    implements EntitySelectorPredicate {
        private final Map<String, Object> conditions;

        public PredicateImpl(Map<String, Object> conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean test(Entity entity) {
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            if (wardrobe == null) {
                return false;
            }
            String id = Objects.safeCast(this.conditions.get("id"), String.class);
            SkinSlotType type = Objects.flatMap(this.conditions.get("type"), it -> SkinSlotType.byName((String)it));
            Integer index = Objects.safeCast(this.conditions.get("slot"), Integer.class);
            for (SkinSlotType type1 : SkinSlotType.values()) {
                if (type != null && type != type1 || !this.hasSkinInSlot(id, index, type1, wardrobe)) continue;
                return true;
            }
            return false;
        }

        private boolean hasSkinInSlot(String skinId, @Nullable Integer slotIndex, SkinSlotType slotType, SkinWardrobe wardrobe) {
            int maxSlot = wardrobe.getMaximumSize(slotType);
            for (int i = 0; i < maxSlot; ++i) {
                if (slotIndex != null && i + 1 != slotIndex) continue;
                SkinDescriptor descriptor = SkinDescriptor.of(wardrobe.getItem(slotType, i));
                if (skinId != null) {
                    return skinId.equals(descriptor.identifier());
                }
                return !descriptor.isEmpty();
            }
            return false;
        }
    }
}

