/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class NonNullItemList
extends NonNullList<ItemStack>
implements IDataSerializable.Mutable {
    public NonNullItemList(int size) {
        super(NonNullItemList.buildDefaultList(size), (Object)ItemStack.field_190927_a);
    }

    private static List<ItemStack> buildDefaultList(int size) {
        Object[] objects = new ItemStack[size];
        Arrays.fill(objects, ItemStack.field_190927_a);
        return Arrays.asList(objects);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        int size = this.size();
        ArrayList<Pair> values = new ArrayList<Pair>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = (ItemStack)this.get(i);
            if (itemStack.func_190926_b()) continue;
            values.add(Pair.of((Object)((byte)i), (Object)((ItemStack)this.get(i))));
        }
        serializer.write(CodingKeys.SERIALIZER, values);
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        int size = this.size();
        List<Pair<Byte, ItemStack>> values = serializer.read(CodingKeys.SERIALIZER);
        for (Pair<Byte, ItemStack> pair : values) {
            int slot = (Byte)pair.getFirst() & 0xFF;
            if (slot >= size) continue;
            this.set(slot, (ItemStack)pair.getSecond());
        }
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<List<Pair<Byte, ItemStack>>> SERIALIZER = IDataSerializerKey.create("Items", IDataCodec.pair(IDataCodec.BYTE.fieldOf("Slot").codec(), IDataCodec.ITEM_STACK).listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }
}

