/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import moe.plushie.armourers_workshop.api.skin.texture.ISkinTextureOptions;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class SkinTextureOptions
implements ISkinTextureOptions {
    private long value = 0L;
    private int rotation = 0;

    public SkinTextureOptions() {
    }

    public SkinTextureOptions(long value) {
        this.value = value;
        this.rotation = this.opt2rot((int)value & 0xF);
    }

    public void setRotation(int rotation) {
        this.value &= 0xFFFFFFFFFFFFFFF0L;
        this.value |= (long)this.rot2opt(rotation);
        this.rotation = rotation;
    }

    @Override
    public int rotation() {
        return this.rotation;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0L;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTextureOptions)) {
            return false;
        }
        SkinTextureOptions that = (SkinTextureOptions)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.format("[rotation=%d]", this.rotation);
    }

    private int opt2rot(int opt) {
        int n;
        switch (opt) {
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int rot2opt(int rot) {
        int n;
        switch (rot) {
            case 90: {
                n = 1;
                break;
            }
            case 180: {
                n = 2;
                break;
            }
            case 270: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

