/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import java.util.EnumMap;
import moe.plushie.armourers_workshop.api.core.utils.IDirection;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinTextureBox;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import org.jetbrains.annotations.Nullable;

public class SkinTextureBox
implements ISkinTextureBox {
    private final OpenVector2f texturePos;
    private final SkinTextureData defaultTexture;
    private final float width;
    private final float height;
    private final float depth;
    private final boolean mirror;
    private EnumMap<OpenDirection, OpenRectangle2f> variantRects;
    private EnumMap<OpenDirection, SkinTextureOptions> variantOptions;
    private EnumMap<OpenDirection, SkinTextureData> variantTextures;

    public SkinTextureBox(float width, float height, float depth, boolean mirror, @Nullable OpenVector2f baseUV, @Nullable SkinTextureData defaultTexture) {
        this.texturePos = baseUV;
        this.defaultTexture = defaultTexture;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.mirror = mirror;
    }

    public void putTextureRect(OpenDirection dir, OpenRectangle2f rect) {
        if (this.variantRects == null) {
            this.variantRects = new EnumMap(OpenDirection.class);
        }
        this.variantRects.put(dir, rect);
    }

    public void putTextureOptions(OpenDirection dir, SkinTextureOptions options) {
        if (this.variantOptions == null) {
            this.variantOptions = new EnumMap(OpenDirection.class);
        }
        this.variantOptions.put(dir, options);
    }

    public void putTextureProvider(OpenDirection dir, SkinTextureData textureProvider) {
        if (this.variantTextures == null) {
            this.variantTextures = new EnumMap(OpenDirection.class);
        }
        this.variantTextures.put(dir, textureProvider);
    }

    public SkinTextureBox separated() {
        SkinTextureBox box = new SkinTextureBox(this.width, this.height, this.depth, this.mirror, null, this.defaultTexture);
        for (OpenDirection dir : OpenDirection.values()) {
            SkinTexturePos key = this.getTexture(dir);
            if (key == null) continue;
            box.putTextureRect(dir, new OpenRectangle2f(key.u(), key.v(), key.width(), key.height()));
            if (key.provider() == this.defaultTexture) continue;
            box.putTextureProvider(dir, key.provider());
        }
        return box;
    }

    @Override
    @Nullable
    public SkinTexturePos getTexture(IDirection dir) {
        return this.getTexture((OpenDirection)dir);
    }

    public SkinTexturePos getTexture(OpenDirection dir) {
        SkinTexturePos skinTexturePos;
        if (this.mirror) {
            return this.getMirrorTexture(dir);
        }
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                skinTexturePos = this.makeTexture(dir, this.depth, 0.0f, this.width, this.depth);
                break;
            }
            case DOWN: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width, 0.0f, this.width, this.depth);
                break;
            }
            case NORTH: {
                skinTexturePos = this.makeTexture(dir, this.depth, this.depth, this.width, this.height);
                break;
            }
            case SOUTH: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width + this.depth, this.depth, this.width, this.height);
                break;
            }
            case WEST: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width, this.depth, this.depth, this.height);
                break;
            }
            case EAST: {
                skinTexturePos = this.makeTexture(dir, 0.0f, this.depth, this.depth, this.height);
            }
        }
        return skinTexturePos;
    }

    private SkinTexturePos getMirrorTexture(OpenDirection dir) {
        SkinTexturePos skinTexturePos;
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width, 0.0f, -this.width, this.depth);
                break;
            }
            case DOWN: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width + this.width, 0.0f, -this.width, this.depth);
                break;
            }
            case NORTH: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width, this.depth, -this.width, this.height);
                break;
            }
            case SOUTH: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width + this.depth + this.width, this.depth, -this.width, this.height);
                break;
            }
            case WEST: {
                skinTexturePos = this.makeTexture(dir, 0.0f + this.depth, this.depth, -this.depth, this.height);
                break;
            }
            case EAST: {
                skinTexturePos = this.makeTexture(dir, this.depth + this.width + this.depth, this.depth, -this.depth, this.height);
            }
        }
        return skinTexturePos;
    }

    @Nullable
    private SkinTexturePos makeTexture(OpenDirection dir, float u, float v, float s, float t) {
        SkinTextureData texture = this.getTextureProvider(dir);
        if (texture == null) {
            return null;
        }
        OpenRectangle2f rect = this.getTextureRect(dir);
        if (rect != null) {
            SkinTextureOptions options = this.getTextureOptions(dir);
            return new SkinTexturePos(rect.x(), rect.y(), rect.width(), rect.height(), options, texture);
        }
        OpenVector2f pos = this.texturePos;
        if (pos != null) {
            return new Entry(pos.x() + u, pos.y() + v, s, t, texture, pos);
        }
        return null;
    }

    @Nullable
    private OpenRectangle2f getTextureRect(OpenDirection dir) {
        if (this.variantRects != null) {
            return this.variantRects.get(dir);
        }
        return null;
    }

    private SkinTextureOptions getTextureOptions(OpenDirection dir) {
        if (this.variantOptions != null) {
            return this.variantOptions.get(dir);
        }
        return null;
    }

    private SkinTextureData getTextureProvider(OpenDirection dir) {
        if (this.variantTextures != null) {
            return this.variantTextures.getOrDefault(dir, this.defaultTexture);
        }
        return this.defaultTexture;
    }

    public static class Entry
    extends SkinTexturePos {
        protected final OpenVector2f parent;

        public Entry(float u, float v, float width, float height, SkinTextureData provider, OpenVector2f parent) {
            super(u, v, width, height, provider);
            this.parent = parent;
        }

        public OpenVector2f parent() {
            return this.parent;
        }
    }
}

