/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenSize2i;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.OptimizeContext;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleData;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleFacing;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleMaterial;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.EmitterInitialLocalSpace;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.EmitterInitialization;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterEventLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterExpressionLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterLoopingLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterOnceLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterInstantRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterManualRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterSteadyRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterBoxShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterDiscShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterEntityShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterPointShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterShapeDirection;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterSphereShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialSpeed;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialSpin;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialization;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleBillboardAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleLightingAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleTintingAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleEventLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleExpressLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleKillInBlocksLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleKillInPlaneLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleOnlyInBlocksLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleCollisionMotion;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleDynamicMotion;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleParametricMotion;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockPack;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockParticle;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenExpression;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;
import moe.plushie.armourers_workshop.init.ModConstants;

public class BedrockExporter {
    protected final BedrockPack pack;
    protected final MolangVirtualMachine virtualMachine;

    public BedrockExporter(BedrockPack pack, MolangVirtualMachine virtualMachine) {
        this.pack = pack;
        this.virtualMachine = virtualMachine;
    }

    public SkinParticleData exportParticle(BedrockParticle particle) {
        String name = particle.name();
        SkinParticleMaterial meterial = this.toParticleMaterial(particle.material());
        SkinTextureData texutre = this.toParticleTexture(particle.texture());
        ArrayList<SkinParticleComponent> components = new ArrayList<SkinParticleComponent>();
        for (BedrockComponent component : particle.components().values()) {
            components.add(this.exportParticleComponent(component));
        }
        return new SkinParticleData(name, meterial, texutre, components);
    }

    protected SkinParticleComponent exportParticleComponent(BedrockComponent component) {
        if (component instanceof BedrockComponent.EmitterInitialization) {
            BedrockComponent.EmitterInitialization comp = (BedrockComponent.EmitterInitialization)component;
            OpenPrimitive creation = this.convertToExpression(comp.creation());
            OpenPrimitive update = this.convertToExpression(comp.update());
            return new EmitterInitialization(creation, update);
        }
        if (component instanceof BedrockComponent.EmitterLocalSpace) {
            BedrockComponent.EmitterLocalSpace comp = (BedrockComponent.EmitterLocalSpace)component;
            boolean position = comp.isPosition();
            boolean rotation = comp.isRotation();
            boolean velocity = comp.isVelocity();
            return new EmitterInitialLocalSpace(position, rotation, velocity);
        }
        if (component instanceof BedrockComponent.EmitterSteadyRate) {
            BedrockComponent.EmitterSteadyRate comp = (BedrockComponent.EmitterSteadyRate)component;
            OpenPrimitive spawnRate = this.convertToFloatExpression(comp.spawnRate());
            OpenPrimitive maxParticles = this.convertToIntExpression(comp.maxParticles());
            return new EmitterSteadyRate(spawnRate, maxParticles);
        }
        if (component instanceof BedrockComponent.EmitterInstantRate) {
            BedrockComponent.EmitterInstantRate comp = (BedrockComponent.EmitterInstantRate)component;
            OpenPrimitive particles = this.convertToIntExpression(comp.particles());
            return new EmitterInstantRate(particles);
        }
        if (component instanceof BedrockComponent.EmitterManualRate) {
            BedrockComponent.EmitterManualRate comp = (BedrockComponent.EmitterManualRate)component;
            OpenPrimitive maxParticles = this.convertToIntExpression(comp.maxParticles());
            return new EmitterManualRate(maxParticles);
        }
        if (component instanceof BedrockComponent.EmitterEventLifetime) {
            BedrockComponent.EmitterEventLifetime comp = (BedrockComponent.EmitterEventLifetime)component;
            List<String> creation = comp.creation();
            List<String> expiration = comp.expiration();
            LinkedHashMap<Float, List<String>> timelineEvents = new LinkedHashMap<Float, List<String>>();
            LinkedHashMap<Float, List<String>> travelDistanceEvents = new LinkedHashMap<Float, List<String>>();
            Map<Float, List<String>> travelDistanceLoopEvents = comp.travelDistanceLoopEvents();
            comp.timelineEvents().forEach((key, value) -> timelineEvents.put(Float.valueOf(Float.parseFloat(key)), (List<String>)value));
            comp.travelDistanceEvents().forEach((key, value) -> travelDistanceEvents.put(Float.valueOf(Float.parseFloat(key)), (List<String>)value));
            return new EmitterEventLifetime(creation, expiration, timelineEvents, travelDistanceEvents, travelDistanceLoopEvents);
        }
        if (component instanceof BedrockComponent.EmitterExpressionLifetime) {
            BedrockComponent.EmitterExpressionLifetime comp = (BedrockComponent.EmitterExpressionLifetime)component;
            OpenPrimitive activation = this.convertToExpression(comp.activation());
            OpenPrimitive expiration = this.convertToExpression(comp.expiration());
            return new EmitterExpressionLifetime(activation, expiration);
        }
        if (component instanceof BedrockComponent.EmitterLoopingLifetime) {
            BedrockComponent.EmitterLoopingLifetime comp = (BedrockComponent.EmitterLoopingLifetime)component;
            OpenPrimitive activeTime = this.convertToFloatExpression(comp.activeTime());
            OpenPrimitive sleepTime = this.convertToFloatExpression(comp.sleepTime());
            return new EmitterLoopingLifetime(activeTime, sleepTime);
        }
        if (component instanceof BedrockComponent.EmitterOnceLifetime) {
            BedrockComponent.EmitterOnceLifetime comp = (BedrockComponent.EmitterOnceLifetime)component;
            OpenPrimitive activeTime = this.convertToFloatExpression(comp.activeTime());
            return new EmitterOnceLifetime(activeTime);
        }
        if (component instanceof BedrockComponent.EmitterBoxShape) {
            BedrockComponent.EmitterBoxShape comp = (BedrockComponent.EmitterBoxShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.offsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.offsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.offsetZ());
            OpenPrimitive width = this.convertToFloatExpression(comp.sizeWidth());
            OpenPrimitive height = this.convertToFloatExpression(comp.sizeHeight());
            OpenPrimitive depth = this.convertToFloatExpression(comp.sizeDepth());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.direction());
            return new EmitterBoxShape(offsetX, offsetY, offsetZ, width, height, depth, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.EmitterDiscShape) {
            BedrockComponent.EmitterDiscShape comp = (BedrockComponent.EmitterDiscShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.offsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.offsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.offsetZ());
            OpenPrimitive radius = this.convertToFloatExpression(comp.radius());
            OpenPrimitive planeNormalX = this.convertToFloatExpression(comp.planeNormalX());
            OpenPrimitive planeNormalY = this.convertToFloatExpression(comp.planeNormalY());
            OpenPrimitive planeNormalZ = this.convertToFloatExpression(comp.planeNormalZ());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.direction());
            return new EmitterDiscShape(offsetX, offsetY, offsetZ, radius, planeNormalX, planeNormalY, planeNormalZ, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.EmitterEntityShape) {
            BedrockComponent.EmitterEntityShape comp = (BedrockComponent.EmitterEntityShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.offsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.offsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.offsetZ());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.direction());
            return new EmitterEntityShape(offsetX, offsetY, offsetZ, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.EmitterPointShape) {
            BedrockComponent.EmitterPointShape comp = (BedrockComponent.EmitterPointShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.offsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.offsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.offsetZ());
            EmitterShapeDirection direction = this.toParticleDirection(comp.direction());
            return new EmitterPointShape(offsetX, offsetY, offsetZ, direction);
        }
        if (component instanceof BedrockComponent.EmitterSphereShape) {
            BedrockComponent.EmitterSphereShape comp = (BedrockComponent.EmitterSphereShape)component;
            OpenPrimitive offsetX = this.convertToFloatExpression(comp.offsetX());
            OpenPrimitive offsetY = this.convertToFloatExpression(comp.offsetY());
            OpenPrimitive offsetZ = this.convertToFloatExpression(comp.offsetZ());
            OpenPrimitive radius = this.convertToFloatExpression(comp.radius());
            boolean surfaceOnly = comp.isSurfaceOnly();
            EmitterShapeDirection direction = this.toParticleDirection(comp.direction());
            return new EmitterSphereShape(offsetX, offsetY, offsetZ, radius, direction, surfaceOnly);
        }
        if (component instanceof BedrockComponent.ParticleInitialization) {
            BedrockComponent.ParticleInitialization comp = (BedrockComponent.ParticleInitialization)component;
            OpenPrimitive update = this.convertToExpression(comp.update());
            OpenPrimitive render = this.convertToExpression(comp.render());
            return new ParticleInitialization(update, render);
        }
        if (component instanceof BedrockComponent.ParticleInitialSpeed) {
            BedrockComponent.ParticleInitialSpeed comp = (BedrockComponent.ParticleInitialSpeed)component;
            OpenPrimitive speed = this.convertToFloatExpression(comp.speed());
            return new ParticleInitialSpeed(speed);
        }
        if (component instanceof BedrockComponent.ParticleInitialSpin) {
            BedrockComponent.ParticleInitialSpin comp = (BedrockComponent.ParticleInitialSpin)component;
            OpenPrimitive rotation = this.convertToFloatExpression(comp.rotation());
            OpenPrimitive rotationRate = this.convertToFloatExpression(comp.rotationRate());
            return new ParticleInitialSpin(rotation, rotationRate);
        }
        if (component instanceof BedrockComponent.ParticleEventLifetime) {
            BedrockComponent.ParticleEventLifetime comp = (BedrockComponent.ParticleEventLifetime)component;
            List<String> creation = comp.creation();
            List<String> expiration = comp.expiration();
            LinkedHashMap<Float, List<String>> timelineEvents = new LinkedHashMap<Float, List<String>>();
            comp.timelineEvents().forEach((key, value) -> timelineEvents.put(Float.valueOf(Float.parseFloat(key)), (List<String>)value));
            return new ParticleEventLifetime(creation, expiration, timelineEvents);
        }
        if (component instanceof BedrockComponent.ParticleExpressLifetime) {
            BedrockComponent.ParticleExpressLifetime comp = (BedrockComponent.ParticleExpressLifetime)component;
            OpenPrimitive maxAge = this.convertToIntExpression(comp.maxAge());
            OpenPrimitive expiration = this.convertToExpression(comp.expiration());
            return new ParticleExpressLifetime(maxAge, expiration);
        }
        if (component instanceof BedrockComponent.ParticleKillInBlocksLifetime) {
            BedrockComponent.ParticleKillInBlocksLifetime comp = (BedrockComponent.ParticleKillInBlocksLifetime)component;
            List<String> blocks = comp.blocks();
            return new ParticleKillInBlocksLifetime(blocks);
        }
        if (component instanceof BedrockComponent.ParticleKillInPlaneLifetime) {
            BedrockComponent.ParticleKillInPlaneLifetime comp = (BedrockComponent.ParticleKillInPlaneLifetime)component;
            float a = comp.parameters().get(0).floatValue();
            float b = comp.parameters().get(1).floatValue();
            float c = comp.parameters().get(2).floatValue();
            float d = comp.parameters().get(3).floatValue();
            return new ParticleKillInPlaneLifetime(a, b, c, d);
        }
        if (component instanceof BedrockComponent.ParticleOnlyInBlocksLifetime) {
            BedrockComponent.ParticleOnlyInBlocksLifetime comp = (BedrockComponent.ParticleOnlyInBlocksLifetime)component;
            List<String> blocks = comp.blocks();
            return new ParticleOnlyInBlocksLifetime(blocks);
        }
        if (component instanceof BedrockComponent.ParticleCollisionMotion) {
            BedrockComponent.ParticleCollisionMotion comp = (BedrockComponent.ParticleCollisionMotion)component;
            OpenPrimitive enabled = this.convertToFloatExpression(comp.enabled());
            float collisionDrag = comp.collisionDrag();
            float collisionRadius = comp.collisionRadius();
            float coefficientOfRestitution = comp.coefficientOfRestitution();
            boolean expireOnContact = comp.isExpireOnContact();
            Map<Float, String> events = comp.events();
            return new ParticleCollisionMotion(enabled, collisionDrag, collisionRadius, coefficientOfRestitution, expireOnContact, events);
        }
        if (component instanceof BedrockComponent.ParticleDynamicMotion) {
            BedrockComponent.ParticleDynamicMotion comp = (BedrockComponent.ParticleDynamicMotion)component;
            OpenPrimitive linearAccelerationX = this.convertToFloatExpression(comp.linearAccelerationX());
            OpenPrimitive linearAccelerationY = this.convertToFloatExpression(comp.linearAccelerationY());
            OpenPrimitive linearAccelerationZ = this.convertToFloatExpression(comp.linearAccelerationZ());
            OpenPrimitive linearDragCoefficient = this.convertToFloatExpression(comp.linearDragCoefficient());
            OpenPrimitive rotationAcceleration = this.convertToFloatExpression(comp.rotationAcceleration());
            OpenPrimitive rotationDragCoefficient = this.convertToFloatExpression(comp.rotationDragCoefficient());
            return new ParticleDynamicMotion(linearAccelerationX, linearAccelerationY, linearAccelerationZ, linearDragCoefficient, rotationAcceleration, rotationDragCoefficient);
        }
        if (component instanceof BedrockComponent.ParticleParametricMotion) {
            BedrockComponent.ParticleParametricMotion comp = (BedrockComponent.ParticleParametricMotion)component;
            OpenPrimitive relativePositionX = this.convertToFloatExpression(comp.relativePositionX());
            OpenPrimitive relativePositionY = this.convertToFloatExpression(comp.relativePositionY());
            OpenPrimitive relativePositionZ = this.convertToFloatExpression(comp.relativePositionZ());
            OpenPrimitive directionX = this.convertToFloatExpression(comp.directionX());
            OpenPrimitive directionY = this.convertToFloatExpression(comp.directionY());
            OpenPrimitive directionZ = this.convertToFloatExpression(comp.directionZ());
            OpenPrimitive rotation = this.convertToFloatExpression(comp.rotation());
            return new ParticleParametricMotion(relativePositionX, relativePositionY, relativePositionZ, directionX, directionY, directionZ, rotation);
        }
        if (component instanceof BedrockComponent.ParticleLightingAppearance) {
            BedrockComponent.ParticleLightingAppearance comp = (BedrockComponent.ParticleLightingAppearance)component;
            return new ParticleLightingAppearance();
        }
        if (component instanceof BedrockComponent.ParticleBillboardAppearance) {
            BedrockComponent.ParticleBillboardAppearance comp = (BedrockComponent.ParticleBillboardAppearance)component;
            OpenPrimitive width = this.convertToFloatExpression(comp.width());
            OpenPrimitive height = this.convertToFloatExpression(comp.height());
            SkinParticleFacing facingCameraMode = this.toParticleFacing(comp.facingCameraMode());
            OpenSize2i textureSize = comp.textureSize();
            OpenPrimitive textureCoordsX = this.convertToFloatExpression(comp.textureCoordsX());
            OpenPrimitive textureCoordsY = this.convertToFloatExpression(comp.textureCoordsY());
            OpenPrimitive textureCoordsWidth = this.convertToFloatExpression(comp.textureCoordsWidth());
            OpenPrimitive textureCoordsHeight = this.convertToFloatExpression(comp.textureCoordsHeight());
            OpenPrimitive stepX = this.convertToFloatExpression(comp.stepX());
            OpenPrimitive stepY = this.convertToFloatExpression(comp.stepY());
            boolean isUseAnimation = comp.isUseAnimation();
            int fps = comp.fps();
            OpenPrimitive maxFrame = this.convertToIntExpression(comp.maxFrame());
            boolean isStretchToLifetime = comp.isStretchToLifetime();
            boolean isLoop = comp.isLoop();
            return new ParticleBillboardAppearance(width, height, facingCameraMode, textureSize, textureCoordsX, textureCoordsY, textureCoordsWidth, textureCoordsHeight, stepX, stepY, isUseAnimation, fps, maxFrame, isStretchToLifetime, isLoop);
        }
        if (component instanceof BedrockComponent.ParticleTintingAppearance) {
            BedrockComponent.ParticleTintingAppearance comp = (BedrockComponent.ParticleTintingAppearance)component;
            List<OpenExpression> colors = comp.values();
            if (!colors.isEmpty()) {
                OpenPrimitive red = this.convertToFloatExpression(colors.get(0));
                OpenPrimitive green = this.convertToFloatExpression(colors.get(1));
                OpenPrimitive blue = this.convertToFloatExpression(colors.get(2));
                OpenPrimitive alpha = this.convertToFloatExpression(colors.get(3));
                return new ParticleTintingAppearance(red, green, blue, alpha);
            }
            OpenPrimitive interpolation = this.convertToFloatExpression(comp.interpolation());
            LinkedHashMap<Float, Integer> gradientColors = new LinkedHashMap<Float, Integer>();
            comp.gradientValues().forEach((key, value) -> gradientColors.put(Float.valueOf(Float.parseFloat(key)), Integer.parseInt(value)));
            return new ParticleTintingAppearance(interpolation, gradientColors);
        }
        throw new RuntimeException("can't parse particle component!!");
    }

    private SkinParticleMaterial toParticleMaterial(String material) {
        SkinParticleMaterial skinParticleMaterial;
        switch (material) {
            case "particles_alpha": {
                skinParticleMaterial = SkinParticleMaterial.ALPHA;
                break;
            }
            case "particles_add": {
                skinParticleMaterial = SkinParticleMaterial.ADDITIVE;
                break;
            }
            case "particles_blend": {
                skinParticleMaterial = SkinParticleMaterial.BLEND;
                break;
            }
            case "particles_opaque": {
                skinParticleMaterial = SkinParticleMaterial.OPAQUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown particle material: " + material);
            }
        }
        return skinParticleMaterial;
    }

    private SkinTextureData toParticleTexture(String texture) {
        SkinTextureData skinTextureData;
        switch (texture) {
            case "textures/particle/particles": {
                skinTextureData = this.createBuiltinTexture("textures/particle/particles", 128, 128);
                break;
            }
            case "textures/particle/campfire_smoke": {
                skinTextureData = this.createBuiltinTexture("textures/particle/campfire_smoke", 16, 192);
                break;
            }
            case "textures/particle/flame_atlas": {
                skinTextureData = this.createBuiltinTexture("textures/particle/flame_atlas", 16, 512);
                break;
            }
            case "textures/particle/soul": {
                skinTextureData = this.createBuiltinTexture("textures/particle/soul", 16, 176);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown particle texture: " + texture);
            }
        }
        return skinTextureData;
    }

    private EmitterShapeDirection toParticleDirection(Object direction) {
        if (Objects.equals(direction, "inwards")) {
            return EmitterShapeDirection.outwards();
        }
        if (Objects.equals(direction, "outwards")) {
            return EmitterShapeDirection.outwards();
        }
        if (direction instanceof List) {
            List value = (List)direction;
            OpenPrimitive x = this.convertToFloatExpression((OpenExpression)value.get(0));
            OpenPrimitive y = this.convertToFloatExpression((OpenExpression)value.get(1));
            OpenPrimitive z = this.convertToFloatExpression((OpenExpression)value.get(2));
            return EmitterShapeDirection.custom(x, y, z);
        }
        throw new IllegalArgumentException("unknown particle shape direction: " + direction);
    }

    private SkinParticleFacing toParticleFacing(String name) {
        SkinParticleFacing skinParticleFacing;
        switch (name) {
            case "rotate_xyz": {
                skinParticleFacing = SkinParticleFacing.ROTATE_XYZ;
                break;
            }
            case "rotate_y": {
                skinParticleFacing = SkinParticleFacing.ROTATE_Y;
                break;
            }
            case "lookat_xyz": {
                skinParticleFacing = SkinParticleFacing.LOOKAT_XYZ;
                break;
            }
            case "lookat_y": {
                skinParticleFacing = SkinParticleFacing.LOOKAT_Y;
                break;
            }
            case "lookat_direction": {
                skinParticleFacing = SkinParticleFacing.LOOKAT_DIRECTION;
                break;
            }
            case "direction_x": {
                skinParticleFacing = SkinParticleFacing.DIRECTION_X;
                break;
            }
            case "direction_y": {
                skinParticleFacing = SkinParticleFacing.DIRECTION_Y;
                break;
            }
            case "direction_z": {
                skinParticleFacing = SkinParticleFacing.DIRECTION_Z;
                break;
            }
            case "emitter_transform_xy": {
                skinParticleFacing = SkinParticleFacing.EMITTER_TRANSFORM_XY;
                break;
            }
            case "emitter_transform_xz": {
                skinParticleFacing = SkinParticleFacing.EMITTER_TRANSFORM_XZ;
                break;
            }
            case "emitter_transform_yz": {
                skinParticleFacing = SkinParticleFacing.EMITTER_TRANSFORM_YZ;
                break;
            }
            default: {
                skinParticleFacing = SkinParticleFacing.ROTATE_XYZ;
            }
        }
        return skinParticleFacing;
    }

    private OpenPrimitive convertToExpression(OpenExpression value) {
        Expression expr = this.compileExpression(value);
        if (expr != null && expr.isMutable()) {
            return OpenPrimitive.of(value.expression());
        }
        return OpenPrimitive.NULL;
    }

    private OpenPrimitive convertToIntExpression(OpenExpression value) {
        Expression expr = this.compileExpression(value);
        if (expr != null && expr.isMutable()) {
            return OpenPrimitive.of(value.expression());
        }
        if (expr != null) {
            return OpenPrimitive.of(expr.evaluate(OptimizeContext.DEFAULT).getAsInt());
        }
        return OpenPrimitive.NULL;
    }

    private OpenPrimitive convertToFloatExpression(OpenExpression value) {
        Expression expr = this.compileExpression(value);
        if (expr != null && expr.isMutable()) {
            return OpenPrimitive.of(value.expression());
        }
        if (expr != null) {
            return OpenPrimitive.of((float)expr.compute(OptimizeContext.DEFAULT));
        }
        return OpenPrimitive.NULL;
    }

    private Expression compileExpression(OpenExpression value) {
        try {
            if (value == null) {
                return null;
            }
            String expr = value.expression();
            if (!expr.isEmpty()) {
                return this.virtualMachine.compile(value.expression());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private SkinTextureData createBuiltinTexture(String texture, int width, int height) {
        return new SkinTextureData(ModConstants.key(texture).toString(), width, height);
    }
}

