/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenSize2i;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenExpression;

public class BedrockComponent {

    protected static abstract class ShapeBuilder
    extends Builder {
        OpenExpression offsetX;
        OpenExpression offsetY;
        OpenExpression offsetZ;
        Object direction;
        OpenExpression radius;
        boolean surfaceOnly;

        protected ShapeBuilder() {
        }

        public void offsetX(OpenExpression offsetX) {
            this.offsetX = offsetX;
        }

        public void offsetY(OpenExpression offsetY) {
            this.offsetY = offsetY;
        }

        public void offsetZ(OpenExpression offsetZ) {
            this.offsetZ = offsetZ;
        }

        public void direction(Object direction) {
            this.direction = direction;
        }

        public void radius(OpenExpression radius) {
            this.radius = radius;
        }

        public void surfaceOnly(boolean surfaceOnly) {
            this.surfaceOnly = surfaceOnly;
        }
    }

    protected static abstract class Builder {
        protected Builder() {
        }

        public abstract BedrockComponent build();
    }

    protected static class ParticleTintingAppearance
    extends BedrockComponent {
        private final List<OpenExpression> values;
        private final OpenExpression interpolation;
        private final Map<String, String> gradientValues;

        public ParticleTintingAppearance(List<OpenExpression> values, OpenExpression interpolation, Map<String, String> gradientValues) {
            this.values = values;
            this.interpolation = interpolation;
            this.gradientValues = gradientValues;
        }

        public List<OpenExpression> values() {
            return this.values;
        }

        public OpenExpression interpolation() {
            return this.interpolation;
        }

        public Map<String, String> gradientValues() {
            return this.gradientValues;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            private OpenExpression interpolation;
            private final List<OpenExpression> values = new ArrayList<OpenExpression>();
            private final Map<String, String> gradientValues = new LinkedHashMap<String, String>();

            protected Builder() {
            }

            public void addColor(OpenExpression expression) {
                this.values.add(expression);
            }

            public void interpolation(OpenExpression interpolation) {
                this.interpolation = interpolation;
            }

            public void addColor(String progress, String value) {
                this.gradientValues.put(progress, value);
            }

            @Override
            public BedrockComponent build() {
                return new ParticleTintingAppearance(this.values, this.interpolation, this.gradientValues);
            }
        }
    }

    protected static class ParticleBillboardAppearance
    extends BedrockComponent {
        private final OpenExpression width;
        private final OpenExpression height;
        private final String facingCameraMode;
        private final OpenSize2i textureSize;
        private final OpenExpression textureCoordsX;
        private final OpenExpression textureCoordsY;
        private final OpenExpression textureCoordsWidth;
        private final OpenExpression textureCoordsHeight;
        private final OpenExpression stepX;
        private final OpenExpression stepY;
        private final boolean useAnimation;
        private final int fps;
        private final OpenExpression maxFrame;
        private final boolean stretchToLifetime;
        private final boolean loop;

        public ParticleBillboardAppearance(OpenExpression width, OpenExpression height, String facingCameraMode, OpenSize2i textureSize, OpenExpression textureCoordsX, OpenExpression textureCoordsY, OpenExpression textureCoordsWidth, OpenExpression textureCoordsHeight, OpenExpression stepX, OpenExpression stepY, boolean useAnimation, int fps, OpenExpression maxFrame, boolean stretchToLifetime, boolean loop) {
            this.width = width;
            this.height = height;
            this.facingCameraMode = facingCameraMode;
            this.textureSize = textureSize;
            this.textureCoordsX = textureCoordsX;
            this.textureCoordsY = textureCoordsY;
            this.textureCoordsWidth = textureCoordsWidth;
            this.textureCoordsHeight = textureCoordsHeight;
            this.stepX = stepX;
            this.stepY = stepY;
            this.useAnimation = useAnimation;
            this.fps = fps;
            this.maxFrame = maxFrame;
            this.stretchToLifetime = stretchToLifetime;
            this.loop = loop;
        }

        public OpenExpression width() {
            return this.width;
        }

        public OpenExpression height() {
            return this.height;
        }

        public String facingCameraMode() {
            return this.facingCameraMode;
        }

        public OpenSize2i textureSize() {
            return this.textureSize;
        }

        public OpenExpression textureCoordsX() {
            return this.textureCoordsX;
        }

        public OpenExpression textureCoordsY() {
            return this.textureCoordsY;
        }

        public OpenExpression textureCoordsWidth() {
            return this.textureCoordsWidth;
        }

        public OpenExpression textureCoordsHeight() {
            return this.textureCoordsHeight;
        }

        public OpenExpression stepX() {
            return this.stepX;
        }

        public OpenExpression stepY() {
            return this.stepY;
        }

        public boolean isUseAnimation() {
            return this.useAnimation;
        }

        public int fps() {
            return this.fps;
        }

        public OpenExpression maxFrame() {
            return this.maxFrame;
        }

        public boolean isStretchToLifetime() {
            return this.stretchToLifetime;
        }

        public boolean isLoop() {
            return this.loop;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            private OpenExpression width;
            private OpenExpression height;
            private String facingCameraMode;
            private int textureWidth = 0;
            private int textureHeight = 0;
            private OpenExpression textureCoordsX;
            private OpenExpression textureCoordsY;
            private OpenExpression textureCoordsWidth;
            private OpenExpression textureCoordsHeight;
            private OpenExpression stepX;
            private OpenExpression stepY;
            private boolean useAnimation;
            private int fps;
            private OpenExpression maxFrame;
            private boolean stretchToLifetime;
            private boolean loop;

            protected Builder() {
            }

            public void width(OpenExpression width) {
                this.width = width;
            }

            public void height(OpenExpression height) {
                this.height = height;
            }

            public void facingCameraMode(String facingCameraMode) {
                this.facingCameraMode = facingCameraMode;
            }

            public void textureWidth(int textureWidth) {
                this.textureWidth = textureWidth;
            }

            public void textureHeight(int textureHeight) {
                this.textureHeight = textureHeight;
            }

            public void textureCoordsX(OpenExpression textureCoordsX) {
                this.textureCoordsX = textureCoordsX;
            }

            public void textureCoordsY(OpenExpression textureCoordsY) {
                this.textureCoordsY = textureCoordsY;
            }

            public void textureCoordsWidth(OpenExpression textureCoordsWidth) {
                this.textureCoordsWidth = textureCoordsWidth;
            }

            public void textureCoordsHeight(OpenExpression textureCoordsHeight) {
                this.textureCoordsHeight = textureCoordsHeight;
            }

            public void stepX(OpenExpression uvStepX) {
                this.stepX = uvStepX;
            }

            public void stepY(OpenExpression uvStepY) {
                this.stepY = uvStepY;
            }

            public void useAnimation(boolean useAnimation) {
                this.useAnimation = useAnimation;
            }

            public void fps(int fps) {
                this.fps = fps;
            }

            public void maxFrame(OpenExpression maxFrame) {
                this.maxFrame = maxFrame;
            }

            public void stretchToLifetime(boolean stretchToLifetime) {
                this.stretchToLifetime = stretchToLifetime;
            }

            public void loop(boolean loop) {
                this.loop = loop;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleBillboardAppearance(this.width, this.height, this.facingCameraMode, new OpenSize2i(this.textureWidth, this.textureHeight), this.textureCoordsX, this.textureCoordsY, this.textureCoordsWidth, this.textureCoordsHeight, this.stepX, this.stepY, this.useAnimation, this.fps, this.maxFrame, this.stretchToLifetime, this.loop);
            }
        }
    }

    protected static class ParticleLightingAppearance
    extends BedrockComponent {
        protected ParticleLightingAppearance() {
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            protected Builder() {
            }

            @Override
            public BedrockComponent build() {
                return new ParticleLightingAppearance();
            }
        }
    }

    protected static class ParticleParametricMotion
    extends BedrockComponent {
        private final OpenExpression relativePositionX;
        private final OpenExpression relativePositionY;
        private final OpenExpression relativePositionZ;
        private final OpenExpression directionX;
        private final OpenExpression directionY;
        private final OpenExpression directionZ;
        private final OpenExpression rotation;

        public ParticleParametricMotion(OpenExpression relativePositionX, OpenExpression relativePositionY, OpenExpression relativePositionZ, OpenExpression directionX, OpenExpression directionY, OpenExpression directionZ, OpenExpression rotation) {
            this.relativePositionX = relativePositionX;
            this.relativePositionY = relativePositionY;
            this.relativePositionZ = relativePositionZ;
            this.directionX = directionX;
            this.directionY = directionY;
            this.directionZ = directionZ;
            this.rotation = rotation;
        }

        public OpenExpression relativePositionX() {
            return this.relativePositionX;
        }

        public OpenExpression relativePositionY() {
            return this.relativePositionY;
        }

        public OpenExpression relativePositionZ() {
            return this.relativePositionZ;
        }

        public OpenExpression directionX() {
            return this.directionX;
        }

        public OpenExpression directionY() {
            return this.directionY;
        }

        public OpenExpression directionZ() {
            return this.directionZ;
        }

        public OpenExpression rotation() {
            return this.rotation;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression relativePositionX;
            OpenExpression relativePositionY;
            OpenExpression relativePositionZ;
            OpenExpression directionX;
            OpenExpression directionY;
            OpenExpression directionZ;
            OpenExpression rotation;

            protected Builder() {
            }

            public void relativePositionX(OpenExpression relativePositionX) {
                this.relativePositionX = relativePositionX;
            }

            public void relativePositionY(OpenExpression relativePositionY) {
                this.relativePositionY = relativePositionY;
            }

            public void relativePositionZ(OpenExpression relativePositionZ) {
                this.relativePositionZ = relativePositionZ;
            }

            public void directionX(OpenExpression directionX) {
                this.directionX = directionX;
            }

            public void directionY(OpenExpression directionY) {
                this.directionY = directionY;
            }

            public void directionZ(OpenExpression directionZ) {
                this.directionZ = directionZ;
            }

            public void rotation(OpenExpression rotation) {
                this.rotation = rotation;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleParametricMotion(this.relativePositionX, this.relativePositionY, this.relativePositionZ, this.directionX, this.directionY, this.directionZ, this.rotation);
            }
        }
    }

    protected static class ParticleDynamicMotion
    extends BedrockComponent {
        private final OpenExpression linearAccelerationX;
        private final OpenExpression linearAccelerationY;
        private final OpenExpression linearAccelerationZ;
        private final OpenExpression linearDragCoefficient;
        private final OpenExpression rotationAcceleration;
        private final OpenExpression rotationDragCoefficient;

        public ParticleDynamicMotion(OpenExpression linearAccelerationX, OpenExpression linearAccelerationY, OpenExpression linearAccelerationZ, OpenExpression linearDragCoefficient, OpenExpression rotationAcceleration, OpenExpression rotationDragCoefficient) {
            this.linearAccelerationX = linearAccelerationX;
            this.linearAccelerationY = linearAccelerationY;
            this.linearAccelerationZ = linearAccelerationZ;
            this.linearDragCoefficient = linearDragCoefficient;
            this.rotationAcceleration = rotationAcceleration;
            this.rotationDragCoefficient = rotationDragCoefficient;
        }

        public OpenExpression linearAccelerationX() {
            return this.linearAccelerationX;
        }

        public OpenExpression linearAccelerationY() {
            return this.linearAccelerationY;
        }

        public OpenExpression linearAccelerationZ() {
            return this.linearAccelerationZ;
        }

        public OpenExpression linearDragCoefficient() {
            return this.linearDragCoefficient;
        }

        public OpenExpression rotationAcceleration() {
            return this.rotationAcceleration;
        }

        public OpenExpression rotationDragCoefficient() {
            return this.rotationDragCoefficient;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression linearAccelerationX;
            OpenExpression linearAccelerationY;
            OpenExpression linearAccelerationZ;
            OpenExpression linearDragCoefficient;
            OpenExpression rotationAcceleration;
            OpenExpression rotationDragCoefficient;

            protected Builder() {
            }

            public void linearAccelerationX(OpenExpression linearAccelerationX) {
                this.linearAccelerationX = linearAccelerationX;
            }

            public void linearAccelerationY(OpenExpression linearAccelerationY) {
                this.linearAccelerationY = linearAccelerationY;
            }

            public void linearAccelerationZ(OpenExpression linearAccelerationZ) {
                this.linearAccelerationZ = linearAccelerationZ;
            }

            public void linearDragCoefficient(OpenExpression linearDragCoefficient) {
                this.linearDragCoefficient = linearDragCoefficient;
            }

            public void rotationAcceleration(OpenExpression rotationAcceleration) {
                this.rotationAcceleration = rotationAcceleration;
            }

            public void rotationDragCoefficient(OpenExpression rotationDragCoefficient) {
                this.rotationDragCoefficient = rotationDragCoefficient;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleDynamicMotion(this.linearAccelerationX, this.linearAccelerationY, this.linearAccelerationZ, this.linearDragCoefficient, this.rotationAcceleration, this.rotationDragCoefficient);
            }
        }
    }

    protected static class ParticleCollisionMotion
    extends BedrockComponent {
        private final OpenExpression enabled;
        private final float collisionDrag;
        private final float collisionRadius;
        private final float coefficientOfRestitution;
        private final boolean expireOnContact;
        private final Map<Float, String> events;

        public ParticleCollisionMotion(OpenExpression enabled, float collisionDrag, float collisionRadius, float coefficientOfRestitution, boolean expireOnContact, Map<Float, String> events) {
            this.enabled = enabled;
            this.collisionDrag = collisionDrag;
            this.collisionRadius = collisionRadius;
            this.coefficientOfRestitution = coefficientOfRestitution;
            this.expireOnContact = expireOnContact;
            this.events = events;
        }

        public OpenExpression enabled() {
            return this.enabled;
        }

        public float collisionDrag() {
            return this.collisionDrag;
        }

        public float collisionRadius() {
            return this.collisionRadius;
        }

        public float coefficientOfRestitution() {
            return this.coefficientOfRestitution;
        }

        public boolean isExpireOnContact() {
            return this.expireOnContact;
        }

        public Map<Float, String> events() {
            return this.events;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression enabled;
            float collisionDrag;
            float collisionRadius;
            float coefficientOfRestitution;
            boolean expireOnContact = false;
            Map<Float, String> events = new LinkedHashMap<Float, String>();

            protected Builder() {
            }

            public void enabled(OpenExpression enabled) {
                this.enabled = enabled;
            }

            public void collisionDrag(float collisionDrag) {
                this.collisionDrag = collisionDrag;
            }

            public void collisionRadius(float collisionRadius) {
                this.collisionRadius = collisionRadius;
            }

            public void coefficientOfRestitution(float coefficientOfRestitution) {
                this.coefficientOfRestitution = coefficientOfRestitution;
            }

            public void expireOnContact(boolean expireOnContact) {
                this.expireOnContact = expireOnContact;
            }

            public void event(float minSpeed, String event) {
                this.events.put(Float.valueOf(minSpeed), event);
            }

            @Override
            public BedrockComponent build() {
                return new ParticleCollisionMotion(this.enabled, this.collisionDrag, this.collisionRadius, this.coefficientOfRestitution, this.expireOnContact, this.events);
            }
        }
    }

    protected static class ParticleOnlyInBlocksLifetime
    extends BedrockComponent {
        private final List<String> blocks;

        public ParticleOnlyInBlocksLifetime(List<String> blocks) {
            this.blocks = blocks;
        }

        public List<String> blocks() {
            return this.blocks;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            List<String> blocks = new ArrayList<String>();

            protected Builder() {
            }

            public void add(String block) {
                this.blocks.add(block);
            }

            @Override
            public BedrockComponent build() {
                return new ParticleOnlyInBlocksLifetime(this.blocks);
            }
        }
    }

    protected static class ParticleKillInBlocksLifetime
    extends BedrockComponent {
        private final List<String> blocks;

        public ParticleKillInBlocksLifetime(List<String> blocks) {
            this.blocks = blocks;
        }

        public List<String> blocks() {
            return this.blocks;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            List<String> blocks = new ArrayList<String>();

            protected Builder() {
            }

            public void add(String block) {
                this.blocks.add(block);
            }

            @Override
            public BedrockComponent build() {
                return new ParticleKillInBlocksLifetime(this.blocks);
            }
        }
    }

    protected static class ParticleKillInPlaneLifetime
    extends BedrockComponent {
        private final List<Float> parameters;

        public ParticleKillInPlaneLifetime(List<Float> parameters) {
            this.parameters = parameters;
        }

        public List<Float> parameters() {
            return this.parameters;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            List<Float> parameters = new ArrayList<Float>();

            protected Builder() {
            }

            public void add(float value) {
                this.parameters.add(Float.valueOf(value));
            }

            @Override
            public BedrockComponent build() {
                return new ParticleKillInPlaneLifetime(this.parameters);
            }
        }
    }

    protected static class ParticleExpressLifetime
    extends BedrockComponent {
        private final OpenExpression maxAge;
        private final OpenExpression expiration;

        public ParticleExpressLifetime(OpenExpression maxAge, OpenExpression expiration) {
            this.maxAge = maxAge;
            this.expiration = expiration;
        }

        public OpenExpression maxAge() {
            return this.maxAge;
        }

        public OpenExpression expiration() {
            return this.expiration;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression maxAge;
            OpenExpression expiration;

            protected Builder() {
            }

            public void maxAge(OpenExpression maxAge) {
                this.maxAge = maxAge;
            }

            public void expiration(OpenExpression expiration) {
                this.expiration = expiration;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleExpressLifetime(this.maxAge, this.expiration);
            }
        }
    }

    protected static class ParticleEventLifetime
    extends BedrockComponent {
        private final List<String> creation;
        private final List<String> expiration;
        private final Map<String, List<String>> timelineEvents;

        public ParticleEventLifetime(List<String> creation, List<String> expiration, Map<String, List<String>> timelineEvents) {
            this.creation = creation;
            this.expiration = expiration;
            this.timelineEvents = timelineEvents;
        }

        public List<String> creation() {
            return this.creation;
        }

        public List<String> expiration() {
            return this.expiration;
        }

        public Map<String, List<String>> timelineEvents() {
            return this.timelineEvents;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            List<String> creation = Collections.emptyList();
            List<String> expiration = Collections.emptyList();
            Map<String, List<String>> timelineEvents = new LinkedHashMap<String, List<String>>();

            protected Builder() {
            }

            public void creation(List<String> creation) {
                this.creation = creation;
            }

            public void expiration(List<String> expiration) {
                this.creation = expiration;
            }

            public void timeline(String atTime, List<String> events) {
                this.timelineEvents.put(atTime, events);
            }

            @Override
            public BedrockComponent build() {
                return new ParticleEventLifetime(this.creation, this.expiration, this.timelineEvents);
            }
        }
    }

    protected static class ParticleInitialSpin
    extends BedrockComponent {
        private final OpenExpression rotation;
        private final OpenExpression rotationRate;

        public ParticleInitialSpin(OpenExpression rotation, OpenExpression rotationRate) {
            this.rotation = rotation;
            this.rotationRate = rotationRate;
        }

        public OpenExpression rotation() {
            return this.rotation;
        }

        public OpenExpression rotationRate() {
            return this.rotationRate;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression rotation;
            OpenExpression rotationRate;

            protected Builder() {
            }

            public void rotation(OpenExpression rotation) {
                this.rotation = rotation;
            }

            public void rotationRate(OpenExpression rotationRate) {
                this.rotationRate = rotationRate;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleInitialSpin(this.rotation, this.rotationRate);
            }
        }
    }

    protected static class ParticleInitialSpeed
    extends BedrockComponent {
        private final OpenExpression speed;

        public ParticleInitialSpeed(OpenExpression speed) {
            this.speed = speed;
        }

        public OpenExpression speed() {
            return this.speed;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression speed;

            protected Builder() {
            }

            public void speed(OpenExpression speed) {
                this.speed = speed;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleInitialSpeed(this.speed);
            }
        }
    }

    protected static class ParticleInitialization
    extends BedrockComponent {
        private final OpenExpression update;
        private final OpenExpression render;

        public ParticleInitialization(OpenExpression update, OpenExpression render) {
            this.update = update;
            this.render = render;
        }

        public OpenExpression update() {
            return this.update;
        }

        public OpenExpression render() {
            return this.render;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression update;
            OpenExpression render;

            protected Builder() {
            }

            public void update(OpenExpression update) {
                this.update = update;
            }

            public void render(OpenExpression render) {
                this.render = render;
            }

            @Override
            public BedrockComponent build() {
                return new ParticleInitialization(this.update, this.render);
            }
        }
    }

    protected static class EmitterEntityShape
    extends BedrockComponent {
        private final OpenExpression offsetX;
        private final OpenExpression offsetY;
        private final OpenExpression offsetZ;
        private final boolean surfaceOnly;
        private final Object direction;

        public EmitterEntityShape(OpenExpression offsetX, OpenExpression offsetY, OpenExpression offsetZ, boolean surfaceOnly, Object direction) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.surfaceOnly = surfaceOnly;
            this.direction = direction;
        }

        public OpenExpression offsetX() {
            return this.offsetX;
        }

        public OpenExpression offsetY() {
            return this.offsetY;
        }

        public OpenExpression offsetZ() {
            return this.offsetZ;
        }

        public boolean isSurfaceOnly() {
            return this.surfaceOnly;
        }

        public Object direction() {
            return this.direction;
        }

        protected static class Builder
        extends ShapeBuilder {
            protected Builder() {
            }

            @Override
            public BedrockComponent build() {
                return new EmitterEntityShape(this.offsetX, this.offsetY, this.offsetZ, this.surfaceOnly, this.direction);
            }
        }
    }

    protected static class EmitterDiscShape
    extends BedrockComponent {
        private final OpenExpression offsetX;
        private final OpenExpression offsetY;
        private final OpenExpression offsetZ;
        private final OpenExpression radius;
        private final OpenExpression planeNormalX;
        private final OpenExpression planeNormalY;
        private final OpenExpression planeNormalZ;
        private final boolean surfaceOnly;
        private final Object direction;

        public EmitterDiscShape(OpenExpression offsetX, OpenExpression offsetY, OpenExpression offsetZ, OpenExpression radius, OpenExpression planeNormalX, OpenExpression planeNormalY, OpenExpression planeNormalZ, boolean surfaceOnly, Object direction) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.radius = radius;
            this.planeNormalX = planeNormalX;
            this.planeNormalY = planeNormalY;
            this.planeNormalZ = planeNormalZ;
            this.surfaceOnly = surfaceOnly;
            this.direction = direction;
        }

        public OpenExpression offsetX() {
            return this.offsetX;
        }

        public OpenExpression offsetY() {
            return this.offsetY;
        }

        public OpenExpression offsetZ() {
            return this.offsetZ;
        }

        public OpenExpression radius() {
            return this.radius;
        }

        public OpenExpression planeNormalX() {
            return this.planeNormalX;
        }

        public OpenExpression planeNormalY() {
            return this.planeNormalY;
        }

        public OpenExpression planeNormalZ() {
            return this.planeNormalZ;
        }

        public boolean isSurfaceOnly() {
            return this.surfaceOnly;
        }

        public Object direction() {
            return this.direction;
        }

        protected static class Builder
        extends ShapeBuilder {
            private OpenExpression planeNormalX;
            private OpenExpression planeNormalY;
            private OpenExpression planeNormalZ;

            protected Builder() {
            }

            public void planeNormalX(OpenExpression planeNormalX) {
                this.planeNormalX = planeNormalX;
            }

            public void planeNormalY(OpenExpression planeNormalY) {
                this.planeNormalY = planeNormalY;
            }

            public void planeNormalZ(OpenExpression planeNormalZ) {
                this.planeNormalZ = planeNormalZ;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterDiscShape(this.offsetX, this.offsetY, this.offsetZ, this.radius, this.planeNormalX, this.planeNormalY, this.planeNormalZ, this.surfaceOnly, this.direction);
            }
        }
    }

    protected static class EmitterBoxShape
    extends BedrockComponent {
        private final OpenExpression offsetX;
        private final OpenExpression offsetY;
        private final OpenExpression offsetZ;
        private final OpenExpression sizeWidth;
        private final OpenExpression sizeHeight;
        private final OpenExpression sizeDepth;
        private final boolean surfaceOnly;
        private final Object direction;

        public EmitterBoxShape(OpenExpression offsetX, OpenExpression offsetY, OpenExpression offsetZ, OpenExpression sizeWidth, OpenExpression sizeHeight, OpenExpression sizeDepth, boolean surfaceOnly, Object direction) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.sizeWidth = sizeWidth;
            this.sizeHeight = sizeHeight;
            this.sizeDepth = sizeDepth;
            this.surfaceOnly = surfaceOnly;
            this.direction = direction;
        }

        public OpenExpression offsetX() {
            return this.offsetX;
        }

        public OpenExpression offsetY() {
            return this.offsetY;
        }

        public OpenExpression offsetZ() {
            return this.offsetZ;
        }

        public OpenExpression sizeWidth() {
            return this.sizeWidth;
        }

        public OpenExpression sizeHeight() {
            return this.sizeHeight;
        }

        public OpenExpression sizeDepth() {
            return this.sizeDepth;
        }

        public boolean isSurfaceOnly() {
            return this.surfaceOnly;
        }

        public Object direction() {
            return this.direction;
        }

        protected static class Builder
        extends ShapeBuilder {
            private OpenExpression sizeWidth;
            private OpenExpression sizeHeight;
            private OpenExpression sizeDepth;

            protected Builder() {
            }

            public void width(OpenExpression sizeWidth) {
                this.sizeWidth = sizeWidth;
            }

            public void height(OpenExpression sizeHeight) {
                this.sizeHeight = sizeHeight;
            }

            public void depth(OpenExpression sizeDepth) {
                this.sizeDepth = sizeDepth;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterBoxShape(this.offsetX, this.offsetY, this.offsetZ, this.sizeWidth, this.sizeHeight, this.sizeDepth, this.surfaceOnly, this.direction);
            }
        }
    }

    protected static class EmitterSphereShape
    extends BedrockComponent {
        private final OpenExpression offsetX;
        private final OpenExpression offsetY;
        private final OpenExpression offsetZ;
        private final OpenExpression radius;
        private final boolean surfaceOnly;
        private final Object direction;

        public EmitterSphereShape(OpenExpression offsetX, OpenExpression offsetY, OpenExpression offsetZ, OpenExpression radius, boolean surfaceOnly, Object direction) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.radius = radius;
            this.surfaceOnly = surfaceOnly;
            this.direction = direction;
        }

        public OpenExpression offsetX() {
            return this.offsetX;
        }

        public OpenExpression offsetY() {
            return this.offsetY;
        }

        public OpenExpression offsetZ() {
            return this.offsetZ;
        }

        public OpenExpression radius() {
            return this.radius;
        }

        public boolean isSurfaceOnly() {
            return this.surfaceOnly;
        }

        public Object direction() {
            return this.direction;
        }

        protected static class Builder
        extends ShapeBuilder {
            protected Builder() {
            }

            @Override
            public BedrockComponent build() {
                return new EmitterSphereShape(this.offsetX, this.offsetY, this.offsetZ, this.radius, this.surfaceOnly, this.direction);
            }
        }
    }

    protected static class EmitterPointShape
    extends BedrockComponent {
        private final OpenExpression offsetX;
        private final OpenExpression offsetY;
        private final OpenExpression offsetZ;
        private final Object direction;

        public EmitterPointShape(OpenExpression offsetX, OpenExpression offsetY, OpenExpression offsetZ, Object direction) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.direction = direction;
        }

        public OpenExpression offsetX() {
            return this.offsetX;
        }

        public OpenExpression offsetY() {
            return this.offsetY;
        }

        public OpenExpression offsetZ() {
            return this.offsetZ;
        }

        public Object direction() {
            return this.direction;
        }

        protected static class Builder
        extends ShapeBuilder {
            protected Builder() {
            }

            @Override
            public BedrockComponent build() {
                return new EmitterPointShape(this.offsetX, this.offsetY, this.offsetZ, this.direction);
            }
        }
    }

    protected static class EmitterExpressionLifetime
    extends BedrockComponent {
        private final OpenExpression activation;
        private final OpenExpression expiration;

        public EmitterExpressionLifetime(OpenExpression activation, OpenExpression expiration) {
            this.activation = activation;
            this.expiration = expiration;
        }

        public OpenExpression activation() {
            return this.activation;
        }

        public OpenExpression expiration() {
            return this.expiration;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression activation;
            OpenExpression expiration;

            protected Builder() {
            }

            public void activation(OpenExpression activation) {
                this.activation = activation;
            }

            public void expiration(OpenExpression expiration) {
                this.expiration = expiration;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterExpressionLifetime(this.activation, this.expiration);
            }
        }
    }

    protected static class EmitterOnceLifetime
    extends BedrockComponent {
        private final OpenExpression activeTime;

        public EmitterOnceLifetime(OpenExpression activeTime) {
            this.activeTime = activeTime;
        }

        public OpenExpression activeTime() {
            return this.activeTime;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression activeTime;

            protected Builder() {
            }

            public void activeTime(OpenExpression activeTime) {
                this.activeTime = activeTime;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterOnceLifetime(this.activeTime);
            }
        }
    }

    protected static class EmitterLoopingLifetime
    extends BedrockComponent {
        private final OpenExpression activeTime;
        private final OpenExpression sleepTime;

        public EmitterLoopingLifetime(OpenExpression activeTime, OpenExpression sleepTime) {
            this.activeTime = activeTime;
            this.sleepTime = sleepTime;
        }

        public OpenExpression activeTime() {
            return this.activeTime;
        }

        public OpenExpression sleepTime() {
            return this.sleepTime;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression activeTime;
            OpenExpression sleepTime;

            protected Builder() {
            }

            public void activeTime(OpenExpression activeTime) {
                this.activeTime = activeTime;
            }

            public void sleepTime(OpenExpression sleepTime) {
                this.sleepTime = sleepTime;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterLoopingLifetime(this.activeTime, this.sleepTime);
            }
        }
    }

    protected static class EmitterEventLifetime
    extends BedrockComponent {
        private final List<String> creation;
        private final List<String> expiration;
        private final Map<String, List<String>> timelineEvents;
        private final Map<String, List<String>> travelDistanceEvents;
        private final Map<Float, List<String>> travelDistanceLoopEvents;

        public List<String> creation() {
            return this.creation;
        }

        public List<String> expiration() {
            return this.expiration;
        }

        public Map<String, List<String>> timelineEvents() {
            return this.timelineEvents;
        }

        public Map<String, List<String>> travelDistanceEvents() {
            return this.travelDistanceEvents;
        }

        public Map<Float, List<String>> travelDistanceLoopEvents() {
            return this.travelDistanceLoopEvents;
        }

        public EmitterEventLifetime(List<String> creation, List<String> expiration, Map<String, List<String>> timelineEvents, Map<String, List<String>> travelDistanceEvents, Map<Float, List<String>> travelDistanceLoopEvents) {
            this.creation = creation;
            this.expiration = expiration;
            this.timelineEvents = timelineEvents;
            this.travelDistanceEvents = travelDistanceEvents;
            this.travelDistanceLoopEvents = travelDistanceLoopEvents;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            List<String> creation = Collections.emptyList();
            List<String> expiration = Collections.emptyList();
            Map<String, List<String>> timelineEvents = new LinkedHashMap<String, List<String>>();
            Map<String, List<String>> travelDistanceEvents = new LinkedHashMap<String, List<String>>();
            Map<Float, List<String>> travelDistanceLoopEvents = new LinkedHashMap<Float, List<String>>();

            protected Builder() {
            }

            public void creation(List<String> creation) {
                this.creation = creation;
            }

            public void expiration(List<String> expiration) {
                this.creation = expiration;
            }

            public void timeline(String atTime, List<String> events) {
                this.timelineEvents.put(atTime, events);
            }

            public void travelDistance(String atTime, List<String> events) {
                this.travelDistanceEvents.put(atTime, events);
            }

            public void travelDistanceLoop(float atTime, List<String> events) {
                this.travelDistanceLoopEvents.put(Float.valueOf(atTime), events);
            }

            @Override
            public BedrockComponent build() {
                return new EmitterEventLifetime(this.creation, this.expiration, this.timelineEvents, this.travelDistanceEvents, this.travelDistanceLoopEvents);
            }
        }
    }

    protected static class EmitterManualRate
    extends BedrockComponent {
        private final OpenExpression maxParticles;

        public EmitterManualRate(OpenExpression maxParticles) {
            this.maxParticles = maxParticles;
        }

        public OpenExpression maxParticles() {
            return this.maxParticles;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression maxParticles;

            protected Builder() {
            }

            public void maxParticles(OpenExpression maxParticles) {
                this.maxParticles = maxParticles;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterManualRate(this.maxParticles);
            }
        }
    }

    protected static class EmitterInstantRate
    extends BedrockComponent {
        private final OpenExpression particles;

        public EmitterInstantRate(OpenExpression particles) {
            this.particles = particles;
        }

        public OpenExpression particles() {
            return this.particles;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression particles;

            protected Builder() {
            }

            public void particles(OpenExpression particles) {
                this.particles = particles;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterInstantRate(this.particles);
            }
        }
    }

    protected static class EmitterSteadyRate
    extends BedrockComponent {
        private final OpenExpression spawnRate;
        private final OpenExpression maxParticles;

        public EmitterSteadyRate(OpenExpression spawnRate, OpenExpression maxParticles) {
            this.spawnRate = spawnRate;
            this.maxParticles = maxParticles;
        }

        public OpenExpression spawnRate() {
            return this.spawnRate;
        }

        public OpenExpression maxParticles() {
            return this.maxParticles;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            OpenExpression spawnRate;
            OpenExpression maxParticles;

            protected Builder() {
            }

            public void spawnRate(OpenExpression spawnRate) {
                this.spawnRate = spawnRate;
            }

            public void maxParticles(OpenExpression maxParticles) {
                this.maxParticles = maxParticles;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterSteadyRate(this.spawnRate, this.maxParticles);
            }
        }
    }

    protected static class EmitterLocalSpace
    extends BedrockComponent {
        private final boolean position;
        private final boolean rotation;
        private final boolean velocity;

        public EmitterLocalSpace(boolean position, boolean rotation, boolean velocity) {
            this.position = position;
            this.rotation = rotation;
            this.velocity = velocity;
        }

        public boolean isPosition() {
            return this.position;
        }

        public boolean isRotation() {
            return this.rotation;
        }

        public boolean isVelocity() {
            return this.velocity;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            boolean position = false;
            boolean rotation = false;
            boolean velocity = false;

            protected Builder() {
            }

            public void position(boolean position) {
                this.position = position;
            }

            public void rotation(boolean rotation) {
                this.rotation = rotation;
            }

            public void velocity(boolean velocity) {
                this.velocity = velocity;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterLocalSpace(this.position, this.rotation, this.velocity);
            }
        }
    }

    protected static class EmitterInitialization
    extends BedrockComponent {
        private final OpenExpression creation;
        private final OpenExpression update;

        public EmitterInitialization(OpenExpression creation, OpenExpression update) {
            this.creation = creation;
            this.update = update;
        }

        public OpenExpression creation() {
            return this.creation;
        }

        public OpenExpression update() {
            return this.update;
        }

        protected static class Builder
        extends moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent$Builder {
            private OpenExpression creation;
            private OpenExpression update;

            protected Builder() {
            }

            public void creation(OpenExpression creation) {
                this.creation = creation;
            }

            public void update(OpenExpression update) {
                this.update = update;
            }

            @Override
            public BedrockComponent build() {
                return new EmitterInitialization(this.creation, this.update);
            }
        }
    }
}

