/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.UnsupportedFileFormatException;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v12.SkinSerializerV12;
import moe.plushie.armourers_workshop.core.skin.serializer.v13.SkinSerializerV13;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.SkinSerializerV20;
import moe.plushie.armourers_workshop.core.utils.Collections;
import org.jetbrains.annotations.Nullable;

public class SkinSerializer {
    private static final List<IOSerializer> REGISTERED_SERIALIZERS = Collections.immutableList(builder -> {
        builder.add((Object)new SkinSerializerV20());
        builder.add((Object)new SkinSerializerV13());
        builder.add((Object)new SkinSerializerV12());
    });

    public static void writeToStream(Skin skin, @Nullable SkinFileOptions options, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));){
            SkinSerializer.writeToStream(skin, options, IOutputStream.of(dataOutputStream));
        }
    }

    public static void writeToStream(Skin skin, @Nullable SkinFileOptions options, IOutputStream stream) throws IOException {
        SkinFileOptions options1 = new SkinFileOptions();
        options1.setFileVersion(skin.fileVersion());
        options1.merge(options);
        for (IOSerializer serializer : REGISTERED_SERIALIZERS) {
            if (!serializer.isSupportedVersion(options1)) continue;
            if (serializer.isRequiresHeader()) {
                stream.writeInt(1397442894);
            }
            stream.writeInt(serializer.fileVersion());
            serializer.writeToStream(skin, stream, options1);
            return;
        }
        throw new UnsupportedFileFormatException();
    }

    public static Skin readFromStream(@Nullable SkinFileOptions options, InputStream inputStream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));){
            Skin skin = SkinSerializer.readFromStream(options, IInputStream.of(dataInputStream));
            return skin;
        }
    }

    public static Skin readFromStream(@Nullable SkinFileOptions options, IInputStream stream) throws IOException {
        int fileVersion = stream.readInt();
        if (fileVersion == 1397442894) {
            fileVersion = stream.readInt();
        }
        SkinFileOptions options1 = new SkinFileOptions();
        options1.merge(options);
        options1.setFileVersion(fileVersion);
        for (IOSerializer serializer : REGISTERED_SERIALIZERS) {
            if (!serializer.isSupportedVersion(options1)) continue;
            return serializer.readFromStream(stream, options1);
        }
        throw new UnsupportedFileFormatException();
    }

    public static SkinFileHeader readHeaderFromStream(InputStream inputStream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));){
            SkinFileHeader skinFileHeader = SkinSerializer.readHeaderFromStream(IInputStream.of(dataInputStream));
            return skinFileHeader;
        }
    }

    public static SkinFileHeader readHeaderFromStream(IInputStream stream) throws IOException {
        int fileVersion = stream.readInt();
        if (fileVersion == 1397442894) {
            fileVersion = stream.readInt();
        }
        SkinFileOptions options1 = new SkinFileOptions();
        options1.setFileVersion(fileVersion);
        for (IOSerializer serializer : REGISTERED_SERIALIZERS) {
            if (!serializer.isSupportedVersion(options1)) continue;
            return serializer.readInfoFromStream(stream, options1);
        }
        throw new UnsupportedFileFormatException();
    }

    public static class Versions {
        private static final int HEADER = 1397442894;
        public static final int V12 = 12;
        public static final int V13 = 13;
        public static final int V20 = 20;
        public static final int LATEST = 25;
    }
}

