/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public abstract class EmitterShapeDirection {
    public abstract void writeToStream(IOutputStream var1) throws IOException;

    public boolean isBuiltin() {
        return this instanceof Builtin;
    }

    public static EmitterShapeDirection inwards() {
        return Builtin.INWARDS;
    }

    public static EmitterShapeDirection outwards() {
        return Builtin.OUTWARDS;
    }

    public static EmitterShapeDirection custom(OpenPrimitive x, OpenPrimitive y, OpenPrimitive z) {
        return new Custom(x, y, z);
    }

    public static EmitterShapeDirection readFromStream(IInputStream stream) throws IOException {
        EmitterShapeDirection emitterShapeDirection;
        switch (stream.readByte()) {
            case 0: {
                emitterShapeDirection = Builtin.INWARDS;
                break;
            }
            case 1: {
                emitterShapeDirection = Builtin.OUTWARDS;
                break;
            }
            default: {
                emitterShapeDirection = new Custom(stream);
            }
        }
        return emitterShapeDirection;
    }

    private static class Builtin
    extends EmitterShapeDirection {
        private static final EmitterShapeDirection INWARDS = new Builtin(0, -1.0);
        private static final EmitterShapeDirection OUTWARDS = new Builtin(1, 1.0);
        private final int type;
        private final double factor;

        private Builtin(int type, double factor) {
            this.factor = factor;
            this.type = type;
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeByte(this.type);
        }
    }

    private static class Custom
    extends EmitterShapeDirection {
        private final OpenPrimitive x;
        private final OpenPrimitive y;
        private final OpenPrimitive z;

        public Custom(OpenPrimitive x, OpenPrimitive y, OpenPrimitive z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Custom(IInputStream stream) throws IOException {
            this.x = stream.readPrimitiveObject();
            this.y = stream.readPrimitiveObject();
            this.z = stream.readPrimitiveObject();
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeByte(255);
            stream.writePrimitiveObject(this.x);
            stream.writePrimitiveObject(this.y);
            stream.writePrimitiveObject(this.z);
        }
    }
}

