/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime.test;

import java.util.ArrayList;
import java.util.Map;
import moe.plushie.armourers_workshop.core.client.animation.bind.ClientExecutionContextImpl;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.StaticVariableStorage;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.ContextBinding;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.ObjectBinding;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.function.Function;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompilerTest {
    private ClientExecutionContextImpl context;
    private MolangVirtualMachine virtualMachine = new MolangVirtualMachine((Map<String, ObjectBinding>)Collections.immutableMap(it -> it.put((Object)"test", (Object)new TestBinding())));

    public static void main() {
        try {
            CompilerTest test = new CompilerTest();
            test.context = new ClientExecutionContextImpl(new StaticVariableStorage());
            test.test1();
            test.test2();
            test.test3();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void test1() throws Exception {
        this.assertEquals("-99", -99.0);
        this.assertEquals("!99", 0.0);
        this.assertEquals("1&&2", 1.0);
        this.assertEquals("0&&2", 0.0);
        this.assertEquals("2||2", 1.0);
        this.assertEquals("0||0", 0.0);
        this.assertEquals("1<2", 1.0);
        this.assertEquals("2<2", 0.0);
        this.assertEquals("2<=2", 1.0);
        this.assertEquals("3<=2", 0.0);
        this.assertEquals("2>1", 1.0);
        this.assertEquals("2>2", 0.0);
        this.assertEquals("2>=2", 1.0);
        this.assertEquals("2>=3", 0.0);
        this.assertEquals("2+2", 4.0);
        this.assertEquals("2-2", 0.0);
        this.assertEquals("2*2", 4.0);
        this.assertEquals("2/1", 2.0);
        this.assertEquals("2/0", 0.0);
        this.assertEquals("2%4", 2.0);
        this.assertEquals("2%0", 0.0);
        this.assertEquals("2^3", 8.0);
        this.assertEquals("v.number_value=2", 2.0);
        this.assertEquals("V.NUMBER_VALUE", 2.0);
        this.assertEquals("v.number_value??1", 2.0);
        this.assertEquals("v.null_value??1", 1.0);
        this.assertEquals("v.number_value?1", 1.0);
        this.assertEquals("v.null_value?1", Result.NULL);
        this.assertEquals("'a' == 'a'", 1.0);
        this.assertEquals("'a' == 'b'", 0.0);
        this.assertEquals("'a' != 'a'", 0.0);
        this.assertEquals("'a' != 'b'", 1.0);
        this.assertEquals("'a' != 'A'", 1.0);
        this.assertEquals("1 == 1", 1.0);
        this.assertEquals("1 == 2", 0.0);
        this.assertEquals("1 != 1", 0.0);
        this.assertEquals("1 != 2", 1.0);
        this.assertEquals("t.number.a??=1", 1.0);
        this.assertEquals("t.number.a+=1", 2.0);
        this.assertEquals("t.number.a*=2", 4.0);
        this.assertEquals("t.number.a/=2", 2.0);
        this.assertEquals("t.number.a^=2", 4.0);
        this.assertEquals("t.number.a-=1", 3.0);
        this.assertEquals("t.number.a%=2", 1.0);
        this.assertEquals("test.array_value[-1]", "my_array_1");
        this.assertEquals("test.array_value[-2]", "my_array_1");
        this.assertEquals("test.array_value[0]", "my_array_1");
        this.assertEquals("test.array_value[1]", "my_array_2");
        this.assertEquals("test.array_value[2]", "my_array_3");
        this.assertEquals("test.array_value[3]", "my_array_1");
        this.assertEquals("test.array_value[4]", "my_array_2");
        this.assertEquals("test.array_value[0] == 'my_array_1'", 1.0);
        this.assertEquals("test.array_value[0] == 'my_array_2'", 0.0);
        this.assertEquals("v.number_value == 2 ? test.array_value[0]", "my_array_1");
        this.assertEquals("v.number_value > 2 ? test.array_value[0] : test.array_value[1]", "my_array_2");
        this.assertEquals("v.number_value <= 2 ? test.array_value[0] : test.array_value[1]", "my_array_1");
        this.assertEquals("1 < 2 ? 2 < 3 ? 'a' : 'b' : 'c'", "a");
        this.assertEquals("1 < 2 ? 2 > 3 ? 'a' : 'b' : 'c'", "b");
        this.assertEquals("1 > 2 ? 2 > 3 ? 'a' : 'b' : 'c'", "c");
        this.assertEquals("v.a.b.c = 1", 1.0);
        this.assertEquals("v.a.b.c", 1.0);
        this.assertEquals("V.A.B.C", 1.0);
        this.assertEquals("t.mm = v.a.b;return 1;", 1.0);
        this.assertEquals("t.mm.c", 1.0);
        this.assertEquals("v.a.b.c = 2", 2.0);
        this.assertEquals("v.a.b.c", 2.0);
        this.assertEquals("t.mm.c", 1.0);
        this.assertEquals("math.sin(90)", 1.0);
        this.assertEquals("math.abs(90+1)", 91.0);
        this.assertEquals("-MATH.ABS(-90)", -90.0);
        this.assertEquals("!math.abs(90)", 0.0);
        this.assertEquals("!v.a[0]", 1.0);
        this.assertEquals("-(v.null_value*30)+(v.null_value?-50:-80)", -80.0);
        this.assertEquals("+(v.null_value*30)+(v.null_value?-50:-80)", -80.0);
        this.assertEquals("!(v.null_value*30)*(v.null_value?-50:-80)", -80.0);
        this.assertEquals("variable.x = (variable.x ?? 1.2) + 0.3;", 1.5);
        this.assertEquals("v.x = 0; loop(10, { v.x = v.x + 1; }); return v.x;", 10.0);
        this.assertEquals("v.x = 0; loop(10, { (v.x > 5) ? continue; v.x = v.x + 1; }); return v.x;", 6.0);
        this.assertEquals("v.x = 0; loop(10, { loop(10, { v.x = v.x + 1; (v.x > 5) ? break; }); }); return v.x;", 15.0);
        this.assertEquals("v.x = 0; for_each(t.pig, test.array_value, { v.x = v.x + 1; }); return v.x;", 3.0);
        this.assertEquals("v.x = 0; for_each(t.pig, test.array_value, { (t.pig == 'my_array_2') ? break; v.x = v.x + 1; }); return v.x;", 1.0);
        this.assertEquals("v.x = 0; for_each(t.pig, test.array_value, { (t.pig == 'my_array_2') ? continue; v.x = v.x + 1; }); return v.x;", 2.0);
        this.assertEquals("v.x = 1; v.y = 1; loop(10, { t.x = v.x + v.y; v.x = v.y; v.y = t.x; }); return v.x;", 89.0);
        this.assertEquals("v.pigpig=test.entity_value;return 1;", 1.0);
        this.assertEquals("v.flag=1", 1.0);
        this.assertEquals("v.pigpig->v.flag=2", 2.0);
        this.assertEquals("v.pigpig->v.flag", 2.0);
        this.assertEquals("v.flag", 1.0);
        this.assertEquals("v.cowcow.friend = v.pigpig; v.pigpig->v.test.a.b.c = 1.23; return v.cowcow.friend->v.test.a.b.c;", 1.23);
        this.assertEquals("v.cowcow.friend = v.pigpig; v.pigpig->v.test.a.b.c = 1.23; v.moo = v.cowcow.friend->v.test; return v.moo.a.b.c;", 1.23);
        this.assertEquals("v.cowcow.friend = v.pigpig; v.pigpig->v.test.a.b.c = 1.23; v.moo = v.cowcow.friend->v.test.a; return v.moo.b.c;", 1.23);
        this.assertEquals("v.cowcow.friend = v.pigpig; v.pigpig->v.test.a.b.c = 1.23; v.moo = v.cowcow.friend->v.test.a.b; return v.moo.c;", 1.23);
        this.assertEquals("v.cowcow.friend = v.pigpig; v.pigpig->v.test.a.b.c = 1.23; v.moo = v.cowcow.friend->v.test.a.b.c; return v.moo;", 1.23);
    }

    private void test2() throws Exception {
        this.assertEquals("math.e", Math.E);
        this.assertEquals("math.pi", Math.PI);
        this.assertEquals("math.pi()", Math.PI);
        this.assertEquals("math.sin(q.modified_distance_moved*90)*0.05-0.05", -0.05);
    }

    private void test3() throws Exception {
        this.assertEquals("test.struct_array_value[0].a", "aValue");
        this.assertEquals("test.struct_array_value[0].b", "bValue");
        this.assertEquals("test.struct_func(0).a", "aValue");
        this.assertEquals("test.struct_func(0).b", "bValue");
    }

    private void assertEquals(String source, double expectedValue) throws Exception {
        this.assertEquals(source, Result.valueOf(expectedValue));
    }

    private void assertEquals(String source, String expectedValue) throws Exception {
        this.assertEquals(source, Result.valueOf(expectedValue));
    }

    private void assertEquals(String source, Result expectedValue) throws Exception {
        boolean oldValue = ModConfig.Client.enableMolangDebug;
        ModConfig.Client.enableMolangDebug = true;
        Expression expr = this.virtualMachine.compile(source);
        Result resultValue = expr.evaluate(this.context);
        ModConfig.Client.enableMolangDebug = oldValue;
        if (resultValue.notEquals(expectedValue)) {
            AssertionError exception = new AssertionError((Object)("Source \"" + source + "\", expected " + expectedValue + " but got " + resultValue));
            ArrayList<StackTraceElement> elements = Collections.filter(((Throwable)((Object)exception)).getStackTrace(), it -> !it.getMethodName().equals("assertEquals"));
            ModLog.error("source {}", source);
            ModLog.error("expected {} but got {}", expectedValue, resultValue);
            ModLog.error("at {}", elements.get(0));
        } else {
            ModLog.debug("result: {}", resultValue);
        }
    }

    private static class TestBinding
    extends ContextBinding {
        TestBinding() {
            ArrayList<Result> listValue = new ArrayList<Result>();
            listValue.add(Result.valueOf("my_array_1"));
            listValue.add(Result.valueOf("my_array_2"));
            listValue.add(Result.valueOf("my_array_3"));
            this.constant("array_value", Result.valueOf(listValue));
            ArrayList<Result> listValue2 = new ArrayList<Result>();
            final Result rr2 = Result.newStruct();
            rr2.set(Name.of("a"), Result.valueOf("aValue"));
            rr2.set(Name.of("b"), Result.valueOf("bValue"));
            listValue2.add(rr2);
            this.constant("struct_array_value", Result.valueOf(listValue2));
            this.constant("entity_value", Result.wrap(new StaticVariableStorage()));
            this.function("struct_func", (r, d) -> new Function(r, 0, d){

                @Override
                public double compute(ExecutionContext context) {
                    return this.evaluate(context).getAsDouble();
                }

                @Override
                public Result evaluate(ExecutionContext context) {
                    return rr2;
                }

                @Override
                public boolean isMutable() {
                    return true;
                }
            });
        }
    }
}

