/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core.ast;

import java.util.function.Function;
import moe.plushie.armourers_workshop.core.skin.molang.core.Assignable;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Optimizable;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.Visitor;

public final class ArrayAccess
implements Expression,
Optimizable,
Assignable {
    private final Expression receiver;
    private final Expression index;

    public ArrayAccess(Expression receiver, Expression index) {
        this.receiver = receiver;
        this.index = index;
    }

    @Override
    public Result assign(Result value, ExecutionContext context) {
        Result result = this.receiver.evaluate(context);
        int idx = this.index.evaluate(context).getAsInt();
        result.set(idx, value);
        return value;
    }

    @Override
    public Result assign(Function<Result, Result> operator, ExecutionContext context) {
        Result result = this.receiver.evaluate(context);
        int idx = this.index.evaluate(context).getAsInt();
        Result value = operator.apply(result.get(idx));
        result.set(idx, value);
        return value;
    }

    @Override
    public Result evaluate(ExecutionContext context) {
        Result result = this.receiver.evaluate(context);
        int idx = this.index.evaluate(context).getAsInt();
        return result.get(idx);
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitArrayAccess(this);
    }

    @Override
    public boolean isMutable() {
        return this.receiver.isMutable() || this.index.isMutable();
    }

    public String toString() {
        return this.receiver + "[" + this.index + "]";
    }

    public Expression receiver() {
        return this.receiver;
    }

    public Expression index() {
        return this.index;
    }
}

