/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.function.BooleanSupplier;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.api.skin.ISkinDescriptor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.ItemStackStorage;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class SkinDescriptor
implements ISkinDescriptor,
IDataSerializable.Immutable {
    public static final SkinDescriptor EMPTY = new SkinDescriptor("");
    public static final IDataCodec<SkinDescriptor> CODEC = IDataCodec.COMPOUND_TAG.alternative(IDataCodec.STRING, TagSerializer::parse).serializer(SkinDescriptor::new);
    private final String identifier;
    private final SkinType type;
    private final Options options;
    private final SkinPaintScheme paintScheme;
    private ItemStack skinItemStack;

    public SkinDescriptor(String identifier) {
        this(identifier, SkinTypes.UNKNOWN, Options.DEFAULT, SkinPaintScheme.EMPTY);
    }

    public SkinDescriptor(String identifier, SkinType type) {
        this(identifier, type, Options.DEFAULT, SkinPaintScheme.EMPTY);
    }

    public SkinDescriptor(String identifier, SkinType type, SkinPaintScheme paintScheme) {
        this(identifier, type, Options.DEFAULT, paintScheme);
    }

    public SkinDescriptor(String identifier, SkinType type, Options options, SkinPaintScheme paintScheme) {
        this.identifier = identifier;
        this.type = type;
        this.options = options;
        this.paintScheme = paintScheme;
    }

    public SkinDescriptor(IDataSerializer serializer) {
        this.identifier = serializer.read(CodingKeys.IDENTIFIER);
        this.type = serializer.read(CodingKeys.TYPE);
        this.options = serializer.read(CodingKeys.OPTIONS);
        this.paintScheme = serializer.read(CodingKeys.SCHEME);
    }

    public static SkinDescriptor of(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return EMPTY;
        }
        ItemStackStorage storage = ItemStackStorage.of(itemStack);
        SkinDescriptor descriptor = storage.skinDescriptor;
        if (descriptor != null) {
            return descriptor;
        }
        storage.skinDescriptor = descriptor = ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), EMPTY);
        return descriptor;
    }

    public boolean accept(ItemStack itemStack) {
        if (itemStack.func_190926_b() || this.isEmpty()) {
            return false;
        }
        SkinType skinType = this.type();
        if (skinType == SkinTypes.ITEM) {
            return true;
        }
        if (skinType instanceof SkinType.Tool) {
            SkinType.Tool toolType = (SkinType.Tool)skinType;
            return toolType.contains(itemStack);
        }
        return false;
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.IDENTIFIER, this.identifier);
        serializer.write(CodingKeys.TYPE, this.type);
        serializer.write(CodingKeys.OPTIONS, this.options);
        serializer.write(CodingKeys.SCHEME, this.paintScheme);
    }

    public SkinDescriptor withType(SkinType type) {
        return new SkinDescriptor(this.identifier, type, this.options, this.paintScheme);
    }

    public SkinDescriptor withOptions(Options options) {
        return new SkinDescriptor(this.identifier, this.type, options, this.paintScheme);
    }

    public SkinDescriptor withPaintScheme(SkinPaintScheme paintScheme) {
        return new SkinDescriptor(this.identifier, this.type, this.options, paintScheme);
    }

    public ItemStack sharedItemStack() {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (this.skinItemStack != null) {
            return this.skinItemStack;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.SKIN.get());
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), this);
        this.skinItemStack = itemStack;
        return itemStack;
    }

    public ItemStack asItemStack() {
        return this.sharedItemStack().func_77946_l();
    }

    public boolean isEmpty() {
        return this == EMPTY || this.identifier.isEmpty();
    }

    public SkinPaintScheme paintScheme() {
        return this.paintScheme;
    }

    public SkinType type() {
        return this.type;
    }

    public Options options() {
        return this.options;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    public String toString() {
        return String.format("%s@%s[%s]", this.identifier, this.type.registryName().path(), this.type.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinDescriptor)) {
            return false;
        }
        SkinDescriptor that = (SkinDescriptor)o;
        return this.identifier.equals(that.identifier) && this.paintScheme.equals(that.paintScheme);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public static class Options
    implements IDataSerializable.Immutable {
        public static Options DEFAULT = new Options();
        public static final IDataCodec<Options> CODEC = IDataCodec.COMPOUND_TAG.serializer(Options::new);
        private int tooltipFlags = 0;
        private int enableEmbeddedItemRenderer = 0;

        public Options() {
        }

        public Options(IDataSerializer serializer) {
            this.tooltipFlags = serializer.read(CodingKeys.TOOLTIP_FLAGS);
            this.enableEmbeddedItemRenderer = serializer.read(CodingKeys.USING_EMBEDDED_RENDERER);
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            serializer.write(CodingKeys.TOOLTIP_FLAGS, this.tooltipFlags);
            serializer.write(CodingKeys.USING_EMBEDDED_RENDERER, this.enableEmbeddedItemRenderer);
        }

        public Options copy() {
            Options options = new Options();
            options.tooltipFlags = this.tooltipFlags;
            options.enableEmbeddedItemRenderer = this.enableEmbeddedItemRenderer;
            return options;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options that = (Options)o;
            return this.tooltipFlags == that.tooltipFlags && this.enableEmbeddedItemRenderer == that.enableEmbeddedItemRenderer;
        }

        public int hashCode() {
            return Objects.hash(this.tooltipFlags, this.enableEmbeddedItemRenderer);
        }

        public boolean contains(TooltipFlags flags) {
            if ((this.tooltipFlags & flags.flags) != 0) {
                return false;
            }
            return flags.supplier.getAsBoolean();
        }

        public void setTooltip(TooltipFlags flags, boolean newValue) {
            this.tooltipFlags = newValue ? (this.tooltipFlags &= ~flags.flags) : (this.tooltipFlags |= flags.flags);
        }

        public boolean getTooltip(TooltipFlags flags) {
            return (this.tooltipFlags & flags.flags) == 0;
        }

        public void setEnableEmbeddedItemRenderer(int enableEmbeddedItemRenderer) {
            this.enableEmbeddedItemRenderer = enableEmbeddedItemRenderer;
        }

        public int embeddedItemRenderer() {
            return this.enableEmbeddedItemRenderer;
        }
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<String> IDENTIFIER = IDataSerializerKey.create("Identifier", IDataCodec.STRING, "");
        public static final IDataSerializerKey<SkinType> TYPE = IDataSerializerKey.create("SkinType", SkinTypes.CODEC, SkinTypes.UNKNOWN);
        public static final IDataSerializerKey<Options> OPTIONS = IDataSerializerKey.create("SkinOptions", Options.CODEC, Options.DEFAULT);
        public static final IDataSerializerKey<SkinPaintScheme> SCHEME = IDataSerializerKey.create("SkinDyes", SkinPaintScheme.CODEC, SkinPaintScheme.EMPTY);
        public static final IDataSerializerKey<Integer> TOOLTIP_FLAGS = IDataSerializerKey.create("TooltipFlags", IDataCodec.INT, 0);
        public static final IDataSerializerKey<Integer> USING_EMBEDDED_RENDERER = IDataSerializerKey.create("EmbeddedItemRenderer", IDataCodec.INT, 0);

        private CodingKeys() {
        }
    }

    public static enum TooltipFlags {
        NAME(1, () -> ModConfig.Common.tooltipSkinName),
        AUTHOR(2, () -> ModConfig.Common.tooltipSkinAuthor),
        TYPE(4, () -> ModConfig.Common.tooltipSkinType),
        FLAVOUR(8, () -> ModConfig.Common.tooltipFlavour),
        HAS_SKIN(16, () -> ModConfig.Common.tooltipHasSkin),
        OPEN_WARDROBE(32, () -> ModConfig.Common.tooltipHasSkin),
        PREVIEW(128, () -> ModConfig.Common.tooltipSkinPreview);

        private final int flags;
        private final BooleanSupplier supplier;

        private TooltipFlags(int flags, BooleanSupplier supplier) {
            this.flags = flags;
            this.supplier = supplier;
        }
    }
}

