/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.SkinningTableBlockEntity;
import moe.plushie.armourers_workshop.core.menu.SkinningTableMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateSkinningTablePacket
extends CustomPacket {
    private final BlockPos pos;
    private final SkinDescriptor.Options options;

    public UpdateSkinningTablePacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.options = buffer.readNbtWithCodec(SkinDescriptor.Options.CODEC);
    }

    public UpdateSkinningTablePacket(SkinningTableBlockEntity entity, SkinDescriptor.Options options) {
        this.pos = entity.func_174877_v();
        this.options = options;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNbtWithCodec(SkinDescriptor.Options.CODEC, this.options);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        this.apply(player, false);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        this.apply((PlayerEntity)player, true);
    }

    private void apply(PlayerEntity player, boolean needForwarding) {
        TileEntity entity = PropertyProvider.getLevel((Entity)player).func_175625_s(this.pos);
        if (entity instanceof SkinningTableBlockEntity) {
            SkinningTableBlockEntity blockEntity = (SkinningTableBlockEntity)entity;
            Container container = player.field_71070_bA;
            if (container instanceof SkinningTableMenu) {
                SkinningTableMenu menu = (SkinningTableMenu)container;
                blockEntity.setOptions(this.options);
                menu.onCraftSlotChanges();
                if (needForwarding) {
                    NetworkManager.sendToTrackingBlock(this, blockEntity);
                }
            }
        }
    }
}

