/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class CustomPacket {
    private static final HashMap<Integer, Function<IFriendlyByteBuf, CustomPacket>> DECODERS = new HashMap();
    private static final HashMap<Class<? extends CustomPacket>, Integer> ENCODERS = new HashMap();

    public static void register(int id, Class<? extends CustomPacket> clazz, Function<IFriendlyByteBuf, CustomPacket> decoder) {
        ENCODERS.put(clazz, id);
        DECODERS.put(id, decoder);
    }

    public static Function<IFriendlyByteBuf, CustomPacket> getPacketType(int id) {
        return DECODERS.get(id);
    }

    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        throw new UnsupportedOperationException("This packet (" + this.packetId() + ") does not implement a server side handler.");
    }

    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        throw new UnsupportedOperationException("This packet (" + this.packetId() + ") does not implement a client side handler.");
    }

    public void encode(IFriendlyByteBuf buffer) {
    }

    public int packetId() {
        return ENCODERS.getOrDefault(this.getClass(), -1);
    }
}

