/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobeMenu
extends AbstractContainerMenu {
    private final PlayerEntity player;
    private final SkinWardrobe wardrobe;
    private final ArrayList<ItemStack> lastSyncSlot = new ArrayList();
    private final ArrayList<Slot> customSlots = new ArrayList();
    private final int slotsX = 83;
    private final int slotsY = 27;
    private Group group = null;

    public SkinWardrobeMenu(ContainerType<?> menuType, int containerId, PlayerInventory inventory, SkinWardrobe wardrobe) {
        super(menuType, containerId);
        this.wardrobe = wardrobe;
        this.player = inventory.field_70458_d;
        this.addPlayerSlots((IInventory)inventory, 59, 168, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addSkinSlots(SkinSlotType.HEAD, Group.SKINS, 0, 0);
        this.addSkinSlots(SkinSlotType.CHEST, Group.SKINS, 0, 1);
        this.addSkinSlots(SkinSlotType.LEGS, Group.SKINS, 0, 2);
        this.addSkinSlots(SkinSlotType.FEET, Group.SKINS, 0, 3);
        this.addSkinSlots(SkinSlotType.WINGS, Group.SKINS, 0, 4);
        this.addEquipmentSlots(Group.SKINS, 0, 5);
        this.addSkinSlots(SkinSlotType.OUTFIT, Group.OUTFITS, 0, 0);
        this.addSkinSlots(SkinSlotType.BACKPACK, Group.OUTFITS, 0, 5);
        this.addSkinSlots(SkinSlotType.HORSE, Group.UNKNOWN, 0, 0);
        this.addSkinSlots(SkinSlotType.DYE, Group.DYES, 0, 0);
        this.addMannequinSlots(Group.SKINS, 0, 5);
    }

    protected void addEquipmentSlots(Group group, int column, int row) {
        SkinSlotType[] slotTypes = new SkinSlotType[]{SkinSlotType.SWORD, SkinSlotType.SHIELD, SkinSlotType.BOW, SkinSlotType.TRIDENT, null, SkinSlotType.PICKAXE, SkinSlotType.AXE, SkinSlotType.SHOVEL, SkinSlotType.HOE};
        boolean hasContents = false;
        for (SkinSlotType slotType : slotTypes) {
            if (slotType != null) {
                int count = this.wardrobe.getUnlockedSize(slotType);
                if (count <= 0) continue;
                hasContents = true;
                this.addSkinSlots(slotType, group, column, row);
                column += count;
                continue;
            }
            if (!hasContents) continue;
            ++column;
        }
    }

    protected void addMannequinSlots(Group group, int column, int row) {
        Entity entity = this.wardrobe.entity();
        if (entity instanceof MannequinEntity) {
            MannequinEntity entity2 = (MannequinEntity)entity;
            IInventory inventory = entity2.getInventory();
            int size = inventory.func_70302_i_();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                int x = 83 + (column + (size - i - 1)) * 19;
                int y = 27 + row * 19;
                SkinSlot slot = this.addGroupSlot(inventory, i, x, y, group, new SkinSlotType[0]);
                this.customSlots.add(slot);
            }
        }
    }

    protected void addSkinSlots(SkinSlotType slotType, Group group, int column, int row) {
        int index = slotType.index();
        int size = this.wardrobe.getUnlockedSize(slotType);
        IInventory inventory = this.wardrobe.inventory();
        for (int i = 0; i < size; ++i) {
            int x = 83 + (column + i) * 19;
            int y = 27 + row * 19;
            SkinSlot slot = this.addGroupSlot(inventory, index + i, x, y, group, slotType);
            this.customSlots.add(slot);
        }
    }

    protected SkinSlot addGroupSlot(IInventory inventory, int index, int x, int y, final Group group, SkinSlotType ... slotTypes) {
        SkinSlot slot = new SkinSlot(inventory, index, x, y, slotTypes){

            public boolean func_111238_b() {
                return SkinWardrobeMenu.this.group() == group;
            }

            @Override
            public boolean func_75214_a(ItemStack itemStack) {
                if (ModConfig.Common.onlySkinIntoSlots && !Fix16.is(itemStack, (Item)ModItems.SKIN.get())) {
                    return false;
                }
                return super.func_75214_a(itemStack);
            }
        };
        this.func_75146_a(slot);
        return slot;
    }

    public List<Slot> customSlots() {
        return this.customSlots;
    }

    public void forEachCustomSlots(Consumer<Slot> consumer) {
        for (Slot slot : this.customSlots) {
            if (!slot.func_111238_b()) continue;
            consumer.accept(slot);
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        Entity entity = this.entity();
        if (entity == null || !entity.func_70089_S() || !this.wardrobe.isEditable(player)) {
            return false;
        }
        return entity.func_70092_e(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()) <= 64.0;
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (!slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = slot.func_75211_c();
        if (slot instanceof SkinSlot) {
            if (!this.func_75135_a(itemStack, 9, 36, false) && !this.func_75135_a(itemStack, 0, 9, false)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75215_d(ItemStack.field_190927_a);
            return itemStack.func_77946_l();
        }
        SkinSlotType slotType = SkinSlotType.byItem(itemStack);
        if (slotType != null && this.wardrobe.isSupported(slotType)) {
            int startIndex = this.getFreeSlot(slotType);
            if (!this.func_75135_a(itemStack, startIndex, startIndex + 1, false)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75215_d(ItemStack.field_190927_a);
            return itemStack.func_77946_l();
        }
        if (this.wardrobe.entity() instanceof MannequinEntity) {
            int startIndex = this.getFreeSlot(SkinSlotType.ANY);
            if (!this.func_75135_a(itemStack, startIndex, startIndex + 1, false)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75215_d(ItemStack.field_190927_a);
            return itemStack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (PropertyProvider.getLevel((Entity)this.player).func_201670_d()) {
            return;
        }
        if (this.lastSyncSlot.size() != this.field_75151_b.size()) {
            this.lastSyncSlot.ensureCapacity(this.field_75151_b.size());
            this.field_75151_b.forEach(s -> this.lastSyncSlot.add(s.func_75211_c()));
            return;
        }
        int changes = 0;
        for (int index = 0; index < this.field_75151_b.size(); ++index) {
            if (index < 36) continue;
            ItemStack newItemStack = ((Slot)this.field_75151_b.get(index)).func_75211_c();
            if (this.lastSyncSlot.get(index).equals(newItemStack)) continue;
            this.lastSyncSlot.set(index, newItemStack);
            ++changes;
        }
        if (changes != 0) {
            ModLog.debug("observer slots has {} changes, sync to players", changes);
            this.wardrobe.broadcast();
        }
    }

    public boolean shouldRenderInventory() {
        return this.group != null && this.group.shouldRenderInventory();
    }

    private int getFreeSlot(SkinSlotType slotType) {
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SkinSlot)) continue;
            SkinSlot slot1 = (SkinSlot)slot;
            if (slot.func_75216_d() || !slot1.slotTypes().contains((Object)slotType) && !slot1.slotTypes().isEmpty()) continue;
            return slot1.field_75222_d;
        }
        return 0;
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public SkinWardrobe wardrobe() {
        return this.wardrobe;
    }

    @Nullable
    public Entity entity() {
        return this.wardrobe.entity();
    }

    public static enum Group {
        SKINS(true, 99),
        OUTFITS(true, 99),
        UNKNOWN(true, 99),
        DYES(true, 99),
        COLORS(false, 99);

        private final boolean exchanges;
        private final int extendedHeight;

        private Group(boolean exchanges, int extendedHeight) {
            this.exchanges = exchanges;
            this.extendedHeight = extendedHeight;
        }

        public boolean shouldRenderInventory() {
            return this.exchanges;
        }

        public int extendedHeight() {
            return this.extendedHeight;
        }
    }
}

