/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class OpenRay {
    public OpenVector3f origin;
    public OpenVector3f direction;

    public OpenRay(OpenVector3f origin, OpenVector3f direction) {
        this.origin = origin;
        this.direction = direction;
    }

    public boolean intersects(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float ix = 1.0f / this.direction.x();
        float iy = 1.0f / this.direction.y();
        float iz = 1.0f / this.direction.z();
        float t1 = (minX - this.origin.x()) * ix;
        float t2 = (maxX - this.origin.x()) * ix;
        float t3 = (minY - this.origin.y()) * iy;
        float t4 = (maxY - this.origin.y()) * iy;
        float t5 = (minZ - this.origin.z()) * iz;
        float t6 = (maxZ - this.origin.z()) * iz;
        float tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        return tmax >= 0.0f && tmax >= tmin;
    }

    public void transform(IMatrix4f matrix) {
        float[] v1 = new float[]{this.origin.x(), this.origin.y(), this.origin.z(), 1.0f};
        float[] v2 = new float[]{this.direction.x(), this.direction.y(), this.direction.z(), 0.0f};
        matrix.multiply(v1);
        matrix.multiply(v2);
        this.origin = new OpenVector3f(v1);
        this.direction = new OpenVector3f(v2);
    }

    public OpenRay transforming(IMatrix4f matrix) {
        OpenRay ret = this.copy();
        ret.transform(matrix);
        return ret;
    }

    public OpenRay copy() {
        return new OpenRay(this.origin, this.direction);
    }
}

