/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;

public class OpenMatrix4f
implements IMatrix4f {
    private static final OpenMatrix4f IDENTITY = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public OpenMatrix4f() {
    }

    public OpenMatrix4f(IMatrix4f matrix) {
        FloatBuffer buffer = ((FastLocal)FastLocal.LOCALS.get()).buffer;
        matrix.store(buffer);
        this.load(buffer);
    }

    public OpenMatrix4f(IQuaternionf quaternion) {
        this.set(quaternion);
    }

    public OpenMatrix4f(FloatBuffer buffer) {
        this.load(buffer);
    }

    public static OpenMatrix4f createScaleMatrix(float x, float y, float z) {
        OpenMatrix4f matrix = new OpenMatrix4f();
        matrix.m00 = x;
        matrix.m11 = y;
        matrix.m22 = z;
        matrix.m33 = 1.0f;
        return matrix;
    }

    public static OpenMatrix4f createTranslateMatrix(float x, float y, float z) {
        OpenMatrix4f matrix = new OpenMatrix4f();
        matrix.m00 = 1.0f;
        matrix.m11 = 1.0f;
        matrix.m22 = 1.0f;
        matrix.m33 = 1.0f;
        matrix.m30 = x;
        matrix.m31 = y;
        matrix.m32 = z;
        return matrix;
    }

    public static OpenMatrix4f createRotationMatrix(IQuaternionf q) {
        OpenMatrix4f matrix = new OpenMatrix4f();
        matrix.set(q);
        return matrix;
    }

    public static OpenMatrix4f identity() {
        return IDENTITY;
    }

    public static OpenMatrix4f of(IMatrix4f o) {
        if (o instanceof OpenMatrix4f) {
            OpenMatrix4f that = (OpenMatrix4f)o;
            return that;
        }
        return new OpenMatrix4f(o);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.multiply(OpenMatrix4f.createScaleMatrix(x, y, z));
    }

    @Override
    public void translate(float x, float y, float z) {
        this.multiply(OpenMatrix4f.createTranslateMatrix(x, y, z));
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        this.multiply(FastLocal.from(quaternion));
    }

    @Override
    public void set(IMatrix4f matrix) {
        this.set(FastLocal.from(matrix));
    }

    public void set(IQuaternionf q) {
        float w2 = q.w() * q.w();
        float x2 = q.x() * q.x();
        float y2 = q.y() * q.y();
        float z2 = q.z() * q.z();
        float zw = q.z() * q.w();
        float xy = q.x() * q.y();
        float xz = q.x() * q.z();
        float yw = q.y() * q.w();
        float yz = q.y() * q.z();
        float xw = q.x() * q.w();
        this.m00 = w2 + x2 - z2 - y2;
        this.m01 = xy + zw + zw + xy;
        this.m02 = xz - yw + xz - yw;
        this.m03 = 0.0f;
        this.m10 = -zw + xy - zw + xy;
        this.m11 = y2 - z2 + w2 - x2;
        this.m12 = yz + yz + xw + xw;
        this.m13 = 0.0f;
        this.m20 = yw + xz + xz + yw;
        this.m21 = yz + yz - xw - xw;
        this.m22 = z2 - y2 - x2 + w2;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void set(OpenMatrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = 0.0f;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = 0.0f;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void set(OpenMatrix4f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m03 = mat.m03;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m13 = mat.m13;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        this.m23 = mat.m23;
        this.m30 = mat.m30;
        this.m31 = mat.m31;
        this.m32 = mat.m32;
        this.m33 = mat.m33;
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void setTranslation(float x, float y, float z) {
        this.m30 = x;
        this.m31 = y;
        this.m32 = z;
    }

    @Override
    public void multiply(float[] values) {
        float x = values[0];
        float y = values[1];
        float z = values[2];
        float w = values[3];
        values[0] = OpenMath.fma(this.m00, x, OpenMath.fma(this.m10, y, OpenMath.fma(this.m20, z, this.m30 * w)));
        values[1] = OpenMath.fma(this.m01, x, OpenMath.fma(this.m11, y, OpenMath.fma(this.m21, z, this.m31 * w)));
        values[2] = OpenMath.fma(this.m02, x, OpenMath.fma(this.m12, y, OpenMath.fma(this.m22, z, this.m32 * w)));
    }

    @Override
    public void multiply(IMatrix4f other) {
        OpenMatrix4f.multiply(this, FastLocal.from(other), this);
    }

    public void multiplyFront(IMatrix4f other) {
        OpenMatrix4f.multiply(FastLocal.from(other), this, this);
    }

    public void multiplyFront(IQuaternionf quaternion) {
        this.multiplyFront(FastLocal.from(quaternion));
    }

    public void multiply(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m03 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m13 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        this.m23 *= f;
        this.m30 *= f;
        this.m31 *= f;
        this.m32 *= f;
        this.m33 *= f;
    }

    @Override
    public void load(FloatBuffer buffer) {
        this.m00 = buffer.get(OpenMatrix4f.bufferIndex(0, 0));
        this.m01 = buffer.get(OpenMatrix4f.bufferIndex(0, 1));
        this.m02 = buffer.get(OpenMatrix4f.bufferIndex(0, 2));
        this.m03 = buffer.get(OpenMatrix4f.bufferIndex(0, 3));
        this.m10 = buffer.get(OpenMatrix4f.bufferIndex(1, 0));
        this.m11 = buffer.get(OpenMatrix4f.bufferIndex(1, 1));
        this.m12 = buffer.get(OpenMatrix4f.bufferIndex(1, 2));
        this.m13 = buffer.get(OpenMatrix4f.bufferIndex(1, 3));
        this.m20 = buffer.get(OpenMatrix4f.bufferIndex(2, 0));
        this.m21 = buffer.get(OpenMatrix4f.bufferIndex(2, 1));
        this.m22 = buffer.get(OpenMatrix4f.bufferIndex(2, 2));
        this.m23 = buffer.get(OpenMatrix4f.bufferIndex(2, 3));
        this.m30 = buffer.get(OpenMatrix4f.bufferIndex(3, 0));
        this.m31 = buffer.get(OpenMatrix4f.bufferIndex(3, 1));
        this.m32 = buffer.get(OpenMatrix4f.bufferIndex(3, 2));
        this.m33 = buffer.get(OpenMatrix4f.bufferIndex(3, 3));
    }

    @Override
    public void store(FloatBuffer buffer) {
        buffer.put(OpenMatrix4f.bufferIndex(0, 0), this.m00);
        buffer.put(OpenMatrix4f.bufferIndex(0, 1), this.m01);
        buffer.put(OpenMatrix4f.bufferIndex(0, 2), this.m02);
        buffer.put(OpenMatrix4f.bufferIndex(0, 3), this.m03);
        buffer.put(OpenMatrix4f.bufferIndex(1, 0), this.m10);
        buffer.put(OpenMatrix4f.bufferIndex(1, 1), this.m11);
        buffer.put(OpenMatrix4f.bufferIndex(1, 2), this.m12);
        buffer.put(OpenMatrix4f.bufferIndex(1, 3), this.m13);
        buffer.put(OpenMatrix4f.bufferIndex(2, 0), this.m20);
        buffer.put(OpenMatrix4f.bufferIndex(2, 1), this.m21);
        buffer.put(OpenMatrix4f.bufferIndex(2, 2), this.m22);
        buffer.put(OpenMatrix4f.bufferIndex(2, 3), this.m23);
        buffer.put(OpenMatrix4f.bufferIndex(3, 0), this.m30);
        buffer.put(OpenMatrix4f.bufferIndex(3, 1), this.m31);
        buffer.put(OpenMatrix4f.bufferIndex(3, 2), this.m32);
        buffer.put(OpenMatrix4f.bufferIndex(3, 3), this.m33);
    }

    @Override
    public void transpose() {
        float nm10 = this.m01;
        float nm20 = this.m02;
        float nm21 = this.m12;
        float nm30 = this.m03;
        float nm31 = this.m13;
        float nm32 = this.m23;
        this.m01 = this.m10;
        this.m02 = this.m20;
        this.m03 = this.m30;
        this.m10 = nm10;
        this.m12 = this.m21;
        this.m13 = this.m31;
        this.m20 = nm20;
        this.m21 = nm21;
        this.m23 = this.m32;
        this.m30 = nm30;
        this.m31 = nm31;
        this.m32 = nm32;
    }

    @Override
    public void invert() {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float c = this.m00 * this.m13 - this.m03 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float e = this.m01 * this.m13 - this.m03 * this.m11;
        float f = this.m02 * this.m13 - this.m03 * this.m12;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float i = this.m20 * this.m33 - this.m23 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        float k = this.m21 * this.m33 - this.m23 * this.m31;
        float l = this.m22 * this.m33 - this.m23 * this.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0f / det;
        float nm00 = OpenMath.fma(this.m11, l, OpenMath.fma(-this.m12, k, this.m13 * j)) * det;
        float nm01 = OpenMath.fma(-this.m01, l, OpenMath.fma(this.m02, k, -this.m03 * j)) * det;
        float nm02 = OpenMath.fma(this.m31, f, OpenMath.fma(-this.m32, e, this.m33 * d)) * det;
        float nm03 = OpenMath.fma(-this.m21, f, OpenMath.fma(this.m22, e, -this.m23 * d)) * det;
        float nm10 = OpenMath.fma(-this.m10, l, OpenMath.fma(this.m12, i, -this.m13 * h)) * det;
        float nm11 = OpenMath.fma(this.m00, l, OpenMath.fma(-this.m02, i, this.m03 * h)) * det;
        float nm12 = OpenMath.fma(-this.m30, f, OpenMath.fma(this.m32, c, -this.m33 * b)) * det;
        float nm13 = OpenMath.fma(this.m20, f, OpenMath.fma(-this.m22, c, this.m23 * b)) * det;
        float nm20 = OpenMath.fma(this.m10, k, OpenMath.fma(-this.m11, i, this.m13 * g)) * det;
        float nm21 = OpenMath.fma(-this.m00, k, OpenMath.fma(this.m01, i, -this.m03 * g)) * det;
        float nm22 = OpenMath.fma(this.m30, e, OpenMath.fma(-this.m31, c, this.m33 * a)) * det;
        float nm23 = OpenMath.fma(-this.m20, e, OpenMath.fma(this.m21, c, -this.m23 * a)) * det;
        float nm30 = OpenMath.fma(-this.m10, j, OpenMath.fma(this.m11, h, -this.m12 * g)) * det;
        float nm31 = OpenMath.fma(this.m00, j, OpenMath.fma(-this.m01, h, this.m02 * g)) * det;
        float nm32 = OpenMath.fma(-this.m30, d, OpenMath.fma(this.m31, b, -this.m32 * a)) * det;
        float nm33 = OpenMath.fma(this.m20, d, OpenMath.fma(-this.m21, b, this.m22 * a)) * det;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m03 = nm03;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m13 = nm13;
        this.m20 = nm20;
        this.m21 = nm21;
        this.m22 = nm22;
        this.m23 = nm23;
        this.m30 = nm30;
        this.m31 = nm31;
        this.m32 = nm32;
        this.m33 = nm33;
    }

    public OpenMatrix4f copy() {
        return new OpenMatrix4f(this);
    }

    public String toString() {
        return OpenMath.format("%f %f %f %f\n%f %f %f %f\n%f %f %f %f\n%f %f %f %f\n", Float.valueOf(this.m00), Float.valueOf(this.m10), Float.valueOf(this.m20), Float.valueOf(this.m30), Float.valueOf(this.m01), Float.valueOf(this.m11), Float.valueOf(this.m21), Float.valueOf(this.m31), Float.valueOf(this.m02), Float.valueOf(this.m12), Float.valueOf(this.m22), Float.valueOf(this.m32), Float.valueOf(this.m03), Float.valueOf(this.m13), Float.valueOf(this.m23), Float.valueOf(this.m33));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenMatrix4f)) {
            return false;
        }
        OpenMatrix4f that = (OpenMatrix4f)o;
        if (Float.compare(that.m10, this.m10) != 0) {
            return false;
        }
        if (Float.compare(that.m20, this.m20) != 0) {
            return false;
        }
        if (Float.compare(that.m30, this.m30) != 0) {
            return false;
        }
        if (Float.compare(that.m00, this.m00) != 0) {
            return false;
        }
        if (Float.compare(that.m11, this.m11) != 0) {
            return false;
        }
        if (Float.compare(that.m22, this.m22) != 0) {
            return false;
        }
        if (Float.compare(that.m33, this.m33) != 0) {
            return false;
        }
        if (Float.compare(that.m31, this.m31) != 0) {
            return false;
        }
        if (Float.compare(that.m32, this.m32) != 0) {
            return false;
        }
        if (Float.compare(that.m01, this.m01) != 0) {
            return false;
        }
        if (Float.compare(that.m02, this.m02) != 0) {
            return false;
        }
        if (Float.compare(that.m03, this.m03) != 0) {
            return false;
        }
        if (Float.compare(that.m12, this.m12) != 0) {
            return false;
        }
        if (Float.compare(that.m13, this.m13) != 0) {
            return false;
        }
        if (Float.compare(that.m21, this.m21) != 0) {
            return false;
        }
        return Float.compare(that.m23, this.m23) == 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m00);
        result = 31 * result + Float.floatToIntBits(this.m01);
        result = 31 * result + Float.floatToIntBits(this.m02);
        result = 31 * result + Float.floatToIntBits(this.m03);
        result = 31 * result + Float.floatToIntBits(this.m10);
        result = 31 * result + Float.floatToIntBits(this.m11);
        result = 31 * result + Float.floatToIntBits(this.m12);
        result = 31 * result + Float.floatToIntBits(this.m13);
        result = 31 * result + Float.floatToIntBits(this.m20);
        result = 31 * result + Float.floatToIntBits(this.m21);
        result = 31 * result + Float.floatToIntBits(this.m22);
        result = 31 * result + Float.floatToIntBits(this.m23);
        result = 31 * result + Float.floatToIntBits(this.m30);
        result = 31 * result + Float.floatToIntBits(this.m31);
        result = 31 * result + Float.floatToIntBits(this.m32);
        result = 31 * result + Float.floatToIntBits(this.m33);
        return result;
    }

    private static int bufferIndex(int i, int j) {
        return i * 4 + j;
    }

    private static void multiply(OpenMatrix4f left, OpenMatrix4f right, OpenMatrix4f dest) {
        float m00 = OpenMath.fma(left.m00, right.m00, OpenMath.fma(left.m10, right.m01, OpenMath.fma(left.m20, right.m02, left.m30 * right.m03)));
        float m01 = OpenMath.fma(left.m01, right.m00, OpenMath.fma(left.m11, right.m01, OpenMath.fma(left.m21, right.m02, left.m31 * right.m03)));
        float m02 = OpenMath.fma(left.m02, right.m00, OpenMath.fma(left.m12, right.m01, OpenMath.fma(left.m22, right.m02, left.m32 * right.m03)));
        float m03 = OpenMath.fma(left.m03, right.m00, OpenMath.fma(left.m13, right.m01, OpenMath.fma(left.m23, right.m02, left.m33 * right.m03)));
        float m10 = OpenMath.fma(left.m00, right.m10, OpenMath.fma(left.m10, right.m11, OpenMath.fma(left.m20, right.m12, left.m30 * right.m13)));
        float m11 = OpenMath.fma(left.m01, right.m10, OpenMath.fma(left.m11, right.m11, OpenMath.fma(left.m21, right.m12, left.m31 * right.m13)));
        float m12 = OpenMath.fma(left.m02, right.m10, OpenMath.fma(left.m12, right.m11, OpenMath.fma(left.m22, right.m12, left.m32 * right.m13)));
        float m13 = OpenMath.fma(left.m03, right.m10, OpenMath.fma(left.m13, right.m11, OpenMath.fma(left.m23, right.m12, left.m33 * right.m13)));
        float m20 = OpenMath.fma(left.m00, right.m20, OpenMath.fma(left.m10, right.m21, OpenMath.fma(left.m20, right.m22, left.m30 * right.m23)));
        float m21 = OpenMath.fma(left.m01, right.m20, OpenMath.fma(left.m11, right.m21, OpenMath.fma(left.m21, right.m22, left.m31 * right.m23)));
        float m22 = OpenMath.fma(left.m02, right.m20, OpenMath.fma(left.m12, right.m21, OpenMath.fma(left.m22, right.m22, left.m32 * right.m23)));
        float m23 = OpenMath.fma(left.m03, right.m20, OpenMath.fma(left.m13, right.m21, OpenMath.fma(left.m23, right.m22, left.m33 * right.m23)));
        float m30 = OpenMath.fma(left.m00, right.m30, OpenMath.fma(left.m10, right.m31, OpenMath.fma(left.m20, right.m32, left.m30 * right.m33)));
        float m31 = OpenMath.fma(left.m01, right.m30, OpenMath.fma(left.m11, right.m31, OpenMath.fma(left.m21, right.m32, left.m31 * right.m33)));
        float m32 = OpenMath.fma(left.m02, right.m30, OpenMath.fma(left.m12, right.m31, OpenMath.fma(left.m22, right.m32, left.m32 * right.m33)));
        float m33 = OpenMath.fma(left.m03, right.m30, OpenMath.fma(left.m13, right.m31, OpenMath.fma(left.m23, right.m32, left.m33 * right.m33)));
        dest.m00 = m00;
        dest.m01 = m01;
        dest.m02 = m02;
        dest.m03 = m03;
        dest.m10 = m10;
        dest.m11 = m11;
        dest.m12 = m12;
        dest.m13 = m13;
        dest.m20 = m20;
        dest.m21 = m21;
        dest.m22 = m22;
        dest.m23 = m23;
        dest.m30 = m30;
        dest.m31 = m31;
        dest.m32 = m32;
        dest.m33 = m33;
    }

    private static class FastLocal
    extends OpenMatrix4f {
        private static final ThreadLocal<FastLocal> LOCALS = ThreadLocal.withInitial(FastLocal::new);
        private final FloatBuffer buffer = MatrixUtils.createFloatBuffer(16);

        private FastLocal() {
        }

        private static OpenMatrix4f from(IMatrix4f value) {
            if (value instanceof OpenMatrix4f) {
                OpenMatrix4f matrix = (OpenMatrix4f)value;
                return matrix;
            }
            FastLocal local = LOCALS.get();
            value.store(local.buffer);
            local.load(local.buffer);
            return local;
        }

        private static OpenMatrix4f from(IQuaternionf value) {
            FastLocal local = LOCALS.get();
            local.set(value);
            return local;
        }
    }
}

