/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class SkinItem
extends BlockItem
implements IItemPropertiesProvider {
    public SkinItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinSlotType slotType = SkinSlotType.byType(descriptor.type());
        if (descriptor.isEmpty() || slotType == null) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || !wardrobe.isEditable(player) || !wardrobe.isSupported(slotType)) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        int slot = wardrobe.getFreeSlot(slotType);
        if (!wardrobe.getItem(slotType, slot).func_190926_b()) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (level.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        ItemStack resultStack = itemStack.func_77946_l();
        wardrobe.setItem(slotType, slot, resultStack.func_77979_a(1));
        wardrobe.broadcast();
        player.func_184611_a(hand, resultStack);
        return ActionResult.func_226249_b_((Object)itemStack);
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.type() != SkinTypes.BLOCK) {
            return ActionResultType.PASS;
        }
        return super.func_195942_a((BlockItemUseContext)new SkinBlockPlaceContext((ItemUseContext)context));
    }

    public ITextComponent func_200295_i(ItemStack itemStack) {
        Skin skin = SkinLoader.getInstance().getSkin(itemStack);
        if (skin != null && !skin.customName().trim().isEmpty()) {
            return TranslateUtils.formatted(skin.customName());
        }
        if (skin != null) {
            return TranslateUtils.Name.of(skin.type());
        }
        return super.func_200295_i(itemStack);
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("loading"), (itemStack, level, entity, id) -> {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
            if (bakedSkin != null) {
                return 0.0f;
            }
            return (float)descriptor.type().id() / 1000.0f;
        });
    }
}

