/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.ConfigurableToolItem;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;

public class MannequinToolItem
extends ConfigurableToolItem {
    public MannequinToolItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity instanceof MannequinEntity) {
            MannequinEntity mannequinEntity = (MannequinEntity)entity;
            if (player.func_226563_dT_()) {
                CompoundNBT config = new CompoundNBT();
                ItemStack newItemStack = itemStack.func_77946_l();
                mannequinEntity.saveMannequinToolData(config);
                config.func_74778_a("id", ModEntityTypes.MANNEQUIN.registryName().toString());
                ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), config);
                player.func_184611_a(hand, newItemStack);
                return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)player).func_201670_d());
            }
            CompoundNBT entityTag = (CompoundNBT)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
            if (entityTag != null && !entityTag.isEmpty()) {
                mannequinEntity.readMannequinToolData(entityTag, itemStack);
                return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)player).func_201670_d());
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(MannequinToolOptions.MIRROR_MODE);
        builder.accept(MannequinToolOptions.CHANGE_SCALE);
        builder.accept(MannequinToolOptions.CHANGE_ROTATION);
        builder.accept(MannequinToolOptions.CHANGE_TEXTURE);
        builder.accept(MannequinToolOptions.CHANGE_OPTION);
    }

    @Override
    public void appendSettingHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        if (ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get())) {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.settingsSaved", new Object[0]));
        } else {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.noSettingsSaved", new Object[0]));
        }
        super.appendSettingHoverText(itemStack, tooltips);
    }
}

